<?php 
// tabed genre widget
CSF::createWidget('csf_widget_tabbed_genre_new', array(
  'title'       => 'تب تفکیک فیلم و سریال بر اساس ژانر - جدید',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت نمایش مطالب بر اساس ژانر',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),

    array(
      'id'      => 'hide_empty',
      'type'    => 'switcher',
      'title' => 'مخفی کردن ژانر های خالی از محتوا',
      'text_on'  => 'فعال',
      'text_off' => 'غیرفعال',
      'text_width' => 75,
      'default' => false
    ),

  )
));

// tabbed genre new widge
if (!function_exists('csf_widget_tabbed_genre_new')) {
  function csf_widget_tabbed_genre_new($args, $instance)
  { ?>
    <aside class="widget widget-bg col-lg-12">
      <div class="widget_title">
        <h3><i class="fa fa-masks-theater"></i> <?= $instance['title'] ?></h3>
        <ul class="nav nav-pills mb-3" id="pills-tab2" role="tablist">
          <?php
          $hide_empty_genres = $instance['hide_empty'] ? true : false;
          $post_type = get_terms(
            array(
              'taxonomy'   => 'type_of_post',
              'hide_empty' => false
            )
          );
          $genres = get_terms(
            array(
              'taxonomy'   => 'genre',
              'hide_empty' => $hide_empty_genres
            )
          );

          foreach( $post_type as $index => $item ): ?>
          <li class="nav-item" role="presentation">
            <button class="nav-link <?php echo $index == 0 ? 'active' : '' ?>" id="tab_<?php echo $item->slug ?>_button" data-bs-toggle="pill" data-bs-target="#tab_<?php echo $item->slug ?>" type="button" role="tab" aria-selected="true">
              <?php echo $item->name ?>
            </button>
          </li>
          <?php endforeach; ?>
        </ul>
      </div>
      <div class="clearfix"></div>
      <div class="widget_inner">
        <div class="tab-content" id="pills-tabContent2">

          <?php foreach( $post_type as $index => $item ):
            ?>
            <div class="tab-pane fade <?php echo $index == 0 ? 'show active' : '' ?>" id="tab_<?php echo $item->slug ?>" role="tabpanel" aria-labelledby="tab_<?php echo $item->slug ?>">
              <ul class="genre">
                <?php foreach( $genres as $index => $genre ): ?>
                <li>
                  <a class="d-block w-100" href="<?php bloginfo('url') ?>/?search=advanced&post-type=<?php echo $item->slug ?>&_genre=<?php echo $genre->slug ?>">
                    <?php echo $genre->name ?>
                  </a>
                </li>
                <?php endforeach; ?>
              </ul>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </aside>
  <?php
  }
}