<?php

// text ads widget options
CSF::createWidget('csf_widget_text_ads', array(
  'title'       => ' تبلیغات متنی',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای تبلیغات متنی',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'ads_price',
      'type'    => 'text',
      'title'   => 'لینک صفحه تعرفه تبلیغات',
    ),

    array(
      'id'     => 'text_ads',
      'type'   => 'repeater',
      'title'  => 'تبلیغ متنی',
      'button_title' => 'افزودن تبلیغ',
      'fields' => array(

        array(
          'id'    => 'text_ads_title',
          'type'  => 'text',
          'title' => 'عنوان تبلیغ'
        ),
        array(
          'id'    => 'text_ads_desc',
          'type'  => 'text',
          'title' => 'توضیحات تبلیغ'
        ),
        array(
          'id'    => 'text_ads_link',
          'type'  => 'text',
          'title' => 'لینک تبلیغ'
        ),

      ),
    ),
  )
));

// text ads widget
if (!function_exists('csf_widget_text_ads')) {
  function csf_widget_text_ads($args, $instance)
  { ?>
    <aside class="widget col-lg-12">
      <div class="widget_title">
        <h3><i class="fa fa-rectangle-ad"></i><?= $instance['title'] ?></h3>
          <?php if ($instance['ads_price']) : ?>
            <a href="<?= $instance['ads_price']; ?>"><span><?php _e('تعرفه تبلیغات', 'kelaketfilm'); ?></span></a>
          <?php endif; ?>
      </div>
      <div class="clearfix"></div>
      <div class="widget_inner">
        <ul class="_textAds">
          <?php foreach ($instance['text_ads'] as $item) : ?>
            <li>
              <a href="<?= $item['text_ads_link']; ?>">
                <?= $item['text_ads_title']; ?>
                <?php if ($item['text_ads_desc']) : ?>
                  <span><?= $item['text_ads_desc']; ?></span>
                <?php endif; ?>
              </a>
            </li>
          <?php endforeach;?>
        </ul>
      </div>
    </aside>
  <?php
  }
}