<?php 
// updated series widget
CSF::createWidget('csf_widget_updated_series', array(
  'title'       => ' سریال های بروزشده',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای سریال های بروزشده',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'          => 'widget_style',
      'type'        => 'select',
      'title'       => 'استایل ویجت',
      'multiple'    => false,
      'sortable'    => false,
      'options'     => array(
        'style1' => 'طرح پیشفرض',
        'style2' => 'طرح دوم'
      ),
      'default' => 'style1'
    ),
    array(
      'id'          => 'serial_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی سریال',
      'placeholder' => 'دسته بندی سریال را انتخاب کنید',
      'desc'        => 'دسته بندی مادر سریال هارا انتخاب کنید.',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),
    array(
      'id'      => 'count',
      'type'    => 'text',
      'title'   => 'تعداد مطالب',
    ),

  )
));

// updated series widget template
if (!function_exists('csf_widget_updated_series')) {
  function csf_widget_updated_series($args, $instance)
  { ?>
    <aside class="widget <?php echo $instance['widget_style'] ?> col-lg-12">
      <div class="widget_title">
        <h3><i class="fa fa-clapperboard-play"></i> <?= $instance['title'] ?></h3>
          <a href="<?php echo get_category_link($instance['serial_cat']); ?>"><span><?php _e('مشاهده همه', 'kelaketfilm'); ?></span></a>
      </div>
      <div class="clearfix"></div>
      <div class="widget_inner">
        <?php
        $query = new WP_Query(array(
          'post_type' => 'post',
          'meta_key' => 'post-type',
          'meta_value' => 'series',
          'posts_per_page' => $instance['count'],
          'orderby' => 'modified',
          'no_found_rows' => true, // speed up query when we don't need pagination
        ));
        if ($query->have_posts()) :
          while ($query->have_posts()) : $query->the_post(); ?>
            <div class="update">
              <a href="<?php the_permalink(); ?>">
                <?php if (get_field('serial-jadval')) : ?>
                  <img src="<?php the_field('serial-jadval') ?>" alt="<?php the_title(); ?>" />
                <?php else : ?>
                  <?php the_post_thumbnail('post-thumb'); ?>
                <?php endif; ?>
                <div class="update_info">
                  <div class="txt_flow"><?php the_title(); ?></div>
                  <?php if (get_field('update_info')) : ?>
                    <span><?php the_field('update_info'); ?></span>
                  <?php else : ?>
                    <span><?php _e('بروزشده ', 'kelaketfilm') ?> <?php the_modified_time(); ?></span>
                  <?php endif; ?>
                </div>
              </a>
            </div>
          <?php endwhile; ?>
          <?php wp_reset_postdata(); ?>
        <?php endif; ?>
      </div>
    </aside>
  <?php
  }
}