(function ($) {
  $(document).ready(function () {

    $(document).on('keydown', function(event) {
      if (event.key == "Escape") {
        $('.search_modal').slideUp('slow');
      }
    });

    $('.remove_trend_btn').on('click', function () {
      var trend_name = $(this).attr('data-text');
      var this_btn = $(this);
      $.ajax({
        url: ajaxurl,
        data: {
          action: "remove_trend",
          trend_name: trend_name,
          nonce: nonce
        },
        dataType: "json",
        type: "POST",
        cache: false,

        beforeSend: function (xhr) {
          this_btn.prop('disabled', true);

        },
        success: function (response) {
          this_btn.prop('disabled', false);
          this_btn.parent().slideUp('fast');
        },
      });
    });

    $('.post__tags__header').on('click', function () {
      $(this).next().slideToggle();
      $(this).toggleClass('active');
    });

    $('.comment_like_handle button').on('click', function (e) {
      var _this = $(this);
      var action = _this.data('action');
      var comment_id = _this.data('id');
      var nonce = _this.data('nonce');

      $.ajax({
        url: ajaxurl,
        data: {
          action: "comment_vote",
          user_action: action,
          comment_id: comment_id,
          nonce: nonce,
        },
        dataType: "json",
        type: "POST",
        cache: false,

        beforeSend: function (xhr) {
          _this.prop('disabled', true);

          toastr.info('', kelaketfilm.vote_wait, {
            positionClass: "toast-bottom-left",
            progressBar: true,
            timeOut: 1000,
            showMethod: "fadeIn",
            hideMethod: "fadeOut"
          });
        },

        success: function (response) {
          _this.prop('disabled', false);
          //update front-end

          if (response.success) {
            // update count
            console.log(response);
            _this.children().next().text(action == 'like' ? response.data.likes : response.data.dislikes);
            toastr.success('', kelaketfilm.vote_success, {
              positionClass: "toast-bottom-left",
              progressBar: true,
              timeOut: 2000,
              showMethod: "fadeIn",
              hideMethod: "fadeOut"
            });
          } else {
            toastr.error('', response.data.msg, {
              positionClass: "toast-bottom-left",
              progressBar: true,
              timeOut: 2000,
              showMethod: "fadeIn",
              hideMethod: "fadeOut"
            });
          }
        },
      });
    });

    $('#toggle_panel_nav').on('click', function () {
      $('.sidebar').toggleClass('d-none');
      $('.float_menu_holder').toggleClass('make_visibe');
    });

    $('#close_panel_nav').on('click', function () {
      $('.sidebar').toggleClass('d-none');
      $('.float_menu_holder').toggleClass('make_visibe');
    });


    $('.copy-text-btn, #shareLink').on('click', function () {
      var input = $('#shareLink');
      input.select();
      // input.setSelectionRange(0, 99999); 
      navigator.clipboard.writeText(input.val());
      toastr.success('', kelaketfilm.copied, {
        positionClass: "toast-bottom-right",
        progressBar: true,
      });
    });

    $('.comment_spoiler .show_comment').on('click', function () {
      $(this).parent().parent().addClass('d-none');
      $(this).parent().parent().parent().removeClass('has_spoil');
    });

    $(window).on("scroll", function () {
      if ($(this).scrollTop() > 100) {
        $(".go_top").css("right", "0");
      } else {
        $(".go_top").css("right", "-100px");
      }
    });
    $(".go_top").on("click", function (e) {
      e.preventDefault();
      $("html, body").animate({ scrollTop: 0 }, 100);
    });
  
    $('.toggle_more_default').on('click', function () {
      $(this).children().toggleClass('open');
      $('.default_style_more').slideToggle();
    });
    //post_Vote
    $('.post_vote button').on('click', function (e) {
      var post_id = $(this).data('postid');
      var action = $(this).data('action');
      var user_id = $(this).data('userid');
      var nonce = $(this).data('nonce');
      var post_system = $(this).data('post_system');
      var _this = $(this);

      if (post_system === 'users') {
        $.ajax({
          url: ajaxurl,
          data: {
            action: "setVote",
            user_id: user_id,
            user_action: action,
            post_id: post_id,
            nonce: nonce,
          },
          dataType: "json",
          type: "POST",
          cache: false,
  
          beforeSend: function (xhr) {
            $('.post_vote button').prop('disabled', true);
  
            toastr.info('', kelaketfilm.vote_wait, {
              positionClass: "toast-bottom-left",
              progressBar: true,
              timeOut: 1000,
              showMethod: "fadeIn",
              hideMethod: "fadeOut"
            });
          },
  
          success: function (response) {
            $('.post_vote button').prop('disabled', false);
            //update front-end
            if (response.success) {
              $('.vote_stats span').text(response.data.percent+'%');
              $('.vote_stats small').text('(' + response.data.totalVotes + ' ' + kelaketfilm.vote + ' )');
              $('.count_like').text('('+response.data.likes+')');
              $('.count_dislike').text('('+response.data.dislikes+')');
              toastr.success('', kelaketfilm.vote_success, {
                positionClass: "toast-bottom-left",
                progressBar: true,
                timeOut: 2000,
                showMethod: "fadeIn",
                hideMethod: "fadeOut"
              });
            } else {
              toastr.error('', response.data.msg, {
                positionClass: "toast-bottom-left",
                progressBar: true,
                timeOut: 2000,
                showMethod: "fadeIn",
                hideMethod: "fadeOut"
              });
            }
          },
        });
      } else {
        // cookie method
        console.log('cookie');

        $.ajax({
          url: ajaxurl,
          data: {
            action: "setVote_cookie",
            user_id: user_id,
            user_action: action,
            post_id: post_id,
            nonce: nonce,
          },
          dataType: "json",
          type: "POST",
          cache: false,
  
          beforeSend: function (xhr) {
            $('.post_vote button').prop('disabled', true);
  
            toastr.info('', kelaketfilm.vote_wait, {
              positionClass: "toast-bottom-left",
              progressBar: true,
              timeOut: 1000,
              showMethod: "fadeIn",
              hideMethod: "fadeOut"
            });
          },
  
          success: function (response) {
            $('.post_vote button').prop('disabled', false);
            //update front-end
            if (response.success) {
              $('.vote_stats span').text(response.data.percent+'%');
              $('.vote_stats small').text('(' + response.data.totalVotes + ' ' + kelaketfilm.vote + ' )');
              $('.count_like').text('('+response.data.likes+')');
              $('.count_dislike').text('('+response.data.dislikes+')');
              toastr.success('', kelaketfilm.vote_success, {
                positionClass: "toast-bottom-left",
                progressBar: true,
                timeOut: 2000,
                showMethod: "fadeIn",
                hideMethod: "fadeOut"
              });
            } else {
              toastr.error('', response.data.msg, {
                positionClass: "toast-bottom-left",
                progressBar: true,
                timeOut: 2000,
                showMethod: "fadeIn",
                hideMethod: "fadeOut"
              });
            }
          },
        });
      }
    });

    // panel nav
    var panel_submenu = $(".nav_panel .sub-menu").hide();
    $(".nav_panel li.active .sub-menu").show();

    $(".nav_panel li > a").click(function (e) {
      if ($(this).next().is("ul")) {
        e.preventDefault();
        if ($(this).parent().hasClass("child-minus")) {
          $(this).parent().removeClass("child-minus");
          $(this).next().slideUp("500");
        } else {
          panel_submenu.slideUp("500");
          $(".float_menu li").removeClass("child-minus");
          $(this).parent().addClass("child-minus");
          $(this).next().slideDown("500");
        }
        return false;
      }
    });

    var submenu = $(".float_menu .sub-menu").hide();
  
    $(".float_menu li > a").click(function (e) {
      if ($(this).next().is("ul")) {
        e.preventDefault();
        $(this).next().slideToggle();
        return false;
      }
    });

    $('.req_type_wrap span').on('click', function (e) {
      var _this = $(this);
      $('.req_type_wrap span').removeClass('active');
      _this.addClass('active');
      $('#req_type').attr('value', _this.data('value'));
    });

    $('.mobile_adv_trigger').on('click', function (e) {
      $('#mobile_adv_search').toggleClass('active');
    });

    $('.mobile_adv_search_close').on('click', function (e) {
      $('#mobile_adv_search').removeClass('active');
    });

    $('.search_type span').on('click', function (e) {
      var _this = $(this);
      $('.search_type span').removeClass('active');
      _this.addClass('active');
      $('#adv_post-type').attr('value', _this.data('value'));
    });

    $('.ns_select').niceSelect();

    $('.adv_more_filters').on('click', function (e) {
      e.stopPropagation(); 
      // $('#adv_search_more').toggleClass('show');
      if ($('#adv_search_more').hasClass('show')){
        $('#adv_search_more').removeClass('show');
      } else {
        $('#adv_search_more').addClass('show');
      }
    });

    var mouse_is_inside = false;
    $('#adv_search_more').hover(function(){ 
      mouse_is_inside=true; 
    }, function(){ 
      mouse_is_inside=false; 
    });

    $('.adv_more_filters').hover(function(){ 
      mouse_is_inside=true; 
    }, function(){ 
      mouse_is_inside=false; 
    });

    $("body").mouseup(function(e){ 
      if (!mouse_is_inside ) {
        $('#adv_search_more').removeClass('show');
      } 
    });

    $('#clear_visists').on('click', function (e) { 
      e.preventDefault();
      var _this = $(this);

      $.ajax({
        url: ajaxurl,
        data: {
          action: 'clear_recent_history',
          nonce: nonce,
        },
        type: 'POST',
        beforeSend: function (xhr) {

        },
        success: function (res) {
          toastr.success('', res.data.msg, {
            positionClass: "toast-bottom-left",
            progressBar: true,
            timeOut: 2000,
            showMethod: "fadeIn",
            hideMethod: "fadeOut"
          });

          $('.visits_html').html('<span class="widget-bg not_found">'+ res.data.after +'</span>');
        }
      });
 
    });
  

    $('.s_trends li ').on('click', function (e) {
      query = $(e.target).data('value');
      $('.search_modal_input').val(query);
      fetchResults();
    });

    $('.search_modal_input').keyup(function () {
      if ($(this).val().length > 0) {
        $('#datafetch2').show();
        $('#datafetch2').html('<h6>'+kelaketfilm.wait+'</h6>');
        $('.s_trends').fadeOut();
      } else {
        $('#datafetch2').hide();
        $('.s_trends').fadeIn();
      }
    });

    var debounce;
    $('.search_modal_input').on('input', function (e) {
      clearTimeout(debounce);
      debounce = setTimeout(
        function () {
          fetchResults();
        }, 1000
      );
    });

    function fetchResults() {
      var keyword = $('.search_modal_input').val();
      if (keyword == "") {
        $('#datafetch2').html("");
      } else {
        jQuery.ajax({
          url: ajaxurl,
          type: 'post',
          data: {
            action: 'data_fetch2',
            keyword: keyword
          },
          success: function (data) {
            $('#datafetch2').html('');
            $('#datafetch2').html(data);
          }
        });
      }
    }

    $('#searchInput').on('click', function () {
      $('.search_modal').fadeIn('fast');
      $('.search_modal_input').trigger('focus')
    });

    $('#close_search_modal').on('click', function () {
      $('.search_modal').fadeOut('fast');
    });


    // When the user scrolls the page, execute myFunction
    window.onscroll = function() {sticyHeader()};

    // Get the header
    var header = document.querySelector(".header");

    // Get the offset position of the navbar
    var sticky = header.offsetTop;

    // Add the sticky class to the header when you reach its scroll position. Remove "sticky" when you leave the scroll position
    function sticyHeader() {
      if (window.pageYOffset > sticky * 2) {
        header.classList.add("sticky");
      } else {
        header.classList.remove("sticky");
      }
    }

    // var s = $(window).scrollTop();
    // var dh = $(window).height();
    // var previousScroll = 0;
    // var myt = 0;
    // if (s = 0) {
    //   myt = 0;
    // }
    // $(window).scroll(function () {
    //   var currentScroll = $(this).scrollTop();
    //   if (currentScroll < 1) {
    //     $('.top-fixed').removeClass('top-fixed-now0');
    //   }
    //   else {
    //     $('.top-fixed').addClass('top-fixed-now0');
    //   }
    //   if ((currentScroll < previousScroll) || (myt = 0)) {
    //     $('.top-fixed').addClass('top-fixed-now');
    //   }
    //   else {
    //     $('.top-fixed').removeClass('top-fixed-now');
    //   }
    //   previousScroll = currentScroll;
    //   myt = currentScroll;
    // });

    $('#toggleFilters').on('click', function () {
      $('.search_wrap_index').slideToggle();
    });

    if ($('.stars_wrap').height() <= 220) {
      $('.show_more').hide();
    } else {
      $('.stars_wrap').addClass('collapse_stars')
      $('.show_more').show();
    }

    $('.show_more').on('click', function () {
      $('.stars_wrap').toggleClass('collapse_stars', 500);
      if ($('.stars_wrap').hasClass('collapse_stars')) {
        $(this).text(kelaketfilm.more);
      } else {
        $(this).text(kelaketfilm.less);
      }
    });

    function setFavorite(userid, favoriteid) {
      var favorite_field = $(".postFav-" + favoriteid);
      //  var favorite_field = $('[data-js="favorite"]');
      var favorite_label = $('[data-js="favorite_label"]');

      $.ajax({
        url: ajaxurl,
        data: {
          action: "setfavorite",
          userid: userid,
          favoriteid: favoriteid,
          nonce: nonce,
        },
        dataType: "json",
        type: "POST",
        cache: false,

        beforeSend: function (xhr) {
          favorite_field
            .removeClass("far fa fa-bookmark")
            .addClass("fas fa-spinner fa-pulse");
        },

        success: function (data) {
          var icon = data.is_favorite ? "fa fa-bookmark" : "far fa-bookmark";

          favorite_field.parent().toggleClass('bg-danger');

          favorite_field.removeClass("fas fa-spinner fa-pulse");
          favorite_field.addClass(icon);

          favorite_label.html("");
          favorite_label.append(data.favorites_num);
          if (data.error) {
            toastr.error(data.message, kelaketfilm.error, {
              positionClass: "toast-bottom-left",
            });
          } else {
            toastr.success(data.message, kelaketfilm.success_wishlist, {
              positionClass: "toast-bottom-left",
            });
          }
        },
      });
    }

    $("[data-js=favorite]").click(function () {
      var favoriteid = $(this).data("favorite");
      var userid = $(this).data("user");
      setFavorite(userid, favoriteid);
    });

    $(".removeFav").click(function () {
      var postid = $(this).data("id");
      var userid = $(this).data("user");
      if (confirm(kelaketfilm.delete_propmt)) {
        $.ajax({
          url: ajaxurl,
          data: {
            action: "removeFav",
            userid: userid,
            favoriteid: postid,
            nonce: nonce,
          },
          dataType: "json",
          type: "POST",
          cache: false,

          success: function (data) {
            if (data.success) {
              $(".p" + data.id).slideUp("fast");
            }
          },
        });
      }
    });


    $(".night_mode").click(function () {
      $("html").toggleClass("dark");
      if ($("html").hasClass("dark")) {
        localStorage.setItem("theme", "dark");
        $(".dark_toggle").removeClass("fa-sun");
        $(".dark_toggle").addClass("fa-moon");
      } else {
        localStorage.setItem("theme", "light");
        $(".dark_toggle").removeClass("fa-moon");
        $(".dark_toggle").addClass("fa-sun");
      }
    });

    var MobileMenuIcon = $(".mobile_menu_icon");
    var MobileMenu = $(".float_menu");
    var MobileMenuHolder = $(".float_menu_holder");
    var SearchBtn = $(".mobile_search_icon");
    var SearchMobileForm = $(".mobile_search");
    var SearchMobileCloseBtn = $(".close_mobile");

    $(document).mouseup((e) => {
      if (!MobileMenu.is(e.target) && MobileMenu.has(e.target).length === 0) {
        MobileMenu.css("right", "-100%");
        MobileMenuHolder.css("visibility", "hidden");
      }
    });

    MobileMenuIcon.click(function () {
      MobileMenu.css("right", "0px");
      MobileMenuHolder.css("visibility", "visible");
    });

    SearchBtn.click(function () {
      $('.search_modal').fadeIn('fast');
    });

    SearchMobileCloseBtn.click(function () {
      SearchMobileForm.removeClass("active");
    });


    function deviceType() {
      var userAgent = navigator.userAgent;
      if (/(tablet|ipad|playbook|silk)|(android(?!.*mobi))/i.test(userAgent)) {
        return "tablet";
      } else if (
        /Mobile|Android|iP(hone|od)|IEMobile|BlackBerry|Kindle|Silk-Accelerated|(hpw|web)OS|Opera M(obi|ini)/.test(
          userAgent
        )
      ) {
        return "mobile";
      }
    }

    if (deviceType() == 'mobile' || deviceType() == 'tablet') {
      var lastState = JSON.parse(localStorage.getItem("appInstall"));

      if (lastState) {
        //check expire date
        if (new Date().getTime() > lastState.expire) {
          var date = new Date();
          //add 1 day to current day
          date.setDate(date.getDate() + 1);

          localStorage.setItem(
            "appInstall",
            JSON.stringify({ show: true, expire: date.getTime() })
          );
          $(".appInstallBanner").css("display", "flex");
        }
      }
      if (lastState && lastState.show) {
        $(".appInstallBanner").css("display", "flex");
      }
      if (!lastState) {
        $(".appInstallBanner").css("display", "flex");
      }
    }
    $("#dismissApp").click(function (e) {
      $(".appInstallBanner").hide('fast');
      var date = new Date();
      //add 1 day to current day
      date.setDate(date.getDate() + 1);
      //set show false and expire date for tomorrow
      var dismissState = { show: false, expire: date.getTime() };
      localStorage.setItem('appInstall', JSON.stringify(dismissState));
    });

    var lastState2 = JSON.parse(localStorage.getItem("adminNotice"));

    if (lastState2) {
      //check expire date
      if (new Date().getTime() > lastState2.expire) {
        var date = new Date();
        //add 1 day to current day
        date.setDate(date.getDate() + 1);

        localStorage.setItem(
          "adminNotice",
          JSON.stringify({ show: true, expire: date.getTime() })
        );
        $(".adminNotice").css("display", "flex");
      }
    }
    if (lastState2 && lastState2.show) {
      $(".adminNotice").css("display", "flex");
    }
    if (!lastState2) {
      $(".adminNotice").css("display", "flex");
    }
    $("#dismissNotice").click(function (e) {
      $(".adminNotice").hide('fast');
      var date = new Date();
      //add 1 day to current day
      date.setDate(date.getDate() + 1);
      //set show false and expire date for tomorrow
      var dismissState = { show: false, expire: date.getTime() };
      localStorage.setItem('adminNotice', JSON.stringify(dismissState));
    });
    if ($('.pagination').children().length == 0) {
      $('.pagination').hide();
    }

    $("#panel_user").click(function (e) {
      e.preventDefault();
      e.stopPropagation()
      $(".panel_items").toggleClass('active')
    });

    $('html').click(function () {
      $(".panel_items").removeClass('active')
    });


    $('.updated_posts').click(function (e) {
      e.preventDefault();
      if ($('.adv_search').hasClass('active')) {
        $('.sidebar_active').css('right', '8px');
        $('.adv_search').removeClass('active');
        $('.updated_posts').addClass('active');
        $('#widgets_wrap').slideDown(200);
        $('.search_wrap').slideUp(200);
      }
    });
    $('.adv_search').click(function (e) {
      e.preventDefault();
      if ($('.updated_posts').hasClass('active')) {
        $('.sidebar_active').css('right', '50%');
        $('.updated_posts').removeClass('active');
        $('.adv_search').addClass('active');
        $('#widgets_wrap').slideUp(200);
        $('.search_wrap').slideDown(200);

      }
    });

    var searchfilterbox = $('.search_filter_box').hide();

    $('.search_filter a').click(function (e) {
      e.preventDefault();
      if ($(this).parent().hasClass('download-arrow-rotate')) {
        $(this).parent().removeClass('download-arrow-rotate');
        $(this).next().fadeOut('500');
      } else {
        $('.search_filer_box').fadeOut('500');
        // $('.search_filter> .post-content-download-header').removeClass('child-minus');
        $(this).parent().addClass('download-arrow-rotate');
        $(this).next().fadeIn('500');
      }
      return false;
    });



    $('#nav-tabContent').children().first().addClass('active show');
    $('#nav-tab').children().first().addClass('active');
    //check if downloadbox is empty remove DOM
    if ($('.download_inner').children().length == 0) {
      $('.download_inner').remove();
    }

    $("#owl-carousel").owlCarousel({
      items: 6,
      rtl: true,
      loop: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 2,
          nav: true
        },
        600: {
          items: 3,
          nav: false
        },
        1000: {
          items: 6,
          nav: true,
          loop: false
        }
      }
    });

    $(".blog_slider_instance").owlCarousel({
      items: 1,
      rtl: true,
      loop: true,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: true,
    });

    $(".blog_carousel_instance").owlCarousel({
      margin: 20,
      rtl: true,
      loop: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 1,
        },
        600: {
          items: 2,
        },
        1000: {
          items: 3,
        },
        1300: {
          items: 4,
        }
      }
    });

    // mixed slider
    var mixedSlider = $(".mixed-slider").owlCarousel({
      items: 3,
      rtl: false,
      loop: true,
      margin:10,
      stagePadding: 40,
      nav: false,
      autoplay:true,
      autoplayTimeout:5000,
      autoplayHoverPause:true,
      dots: false,
      responsive: {
        0:{
          items:1,
          center: true,
          stagePadding: 80,
          margin:20,
        },
        450:{
            items:3,
            margin: 30
        },
        900:{
            items:2,
        },
        1200:{
            items:3
        }
      }
    });

    var comfortSlider = $(".comfort-slider").owlCarousel({
      items: 6,
      rtl: false,
      loop: true,
      margin: 40,
      center: true,
      autoplay:true,
      autoplayTimeout:5000,
      autoplayHoverPause:true,
      dots: false,
      responsive: {
        0:{
          items:1,
          center: true,
          stagePadding: 80,
          margin:20,
        },
        450:{
          items: 2,
          margin: 20
        },
        650:{
          items: 2,
          margin: 20
        },
        750:{
          items:3,
          // margin: 20
        },
        900:{
            items:5,
        },
        1200:{
            items:6
        }
      }
    });

    

    mixedSlider.on("changed.owl.carousel", function (property) {
      var current = property.item.index;
      var current_slide = $(property.target).find(".owl-item").eq(current).find(".film_cat");
      $('.mixed_slider_title').text(current_slide.data('title'));
      $('.mixed_slider_bg').attr('src', current_slide.data('bg'));
      $('.mixed_slider_link').attr('href', current_slide.data('link'));
      $('.mixed_slider_rate').text(current_slide.data('rate'));
      $('.mixed_slider_icon').attr('href', current_slide.data('link'));
      $('.mixed_slider_imdb').text(current_slide.data('imdb'));
    });

    // comfort slider
    comfortSlider.on("changed.owl.carousel", function (property) {
      var current = property.item.index;
      var current_slide = $(property.target).find(".owl-item").eq(current).find(".film_cat");

      $('.mixed_slider_bg').css('opacity', '0');
      $('.mixed_slider_title').text(current_slide.data('title'));
      $('.mixed_slider_bg').attr('src', current_slide.data('bg'));
      $('.mixed_slider_link').attr('href', current_slide.data('link'));
      $('.mixed_slider_rate').text(current_slide.data('rate'));
      $('.mixed_slider_icon').attr('href', current_slide.data('link'));
      $('.mixed_slider_imdb').text(current_slide.data('imdb'));
      setTimeout(function () {
      $('.mixed_slider_bg').css('opacity', '1');
      }, 400);
    });



    var owl = $("#owl-slider").owlCarousel({
      items: 1,
      rtl: true,
      loop: true,
      singleItem: true,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      autoplay: true,
      autoplayTimeout: 7300,
      onTranslate: function () { },
    });

    owl.on("changed.owl.carousel", function (event) {
    });

    $(".sidebar_carousel").owlCarousel({
      items: 3,
      rtl: true,
      loop: false,
      autoplay: true,
      nav: false,
      //navText: ["",""],
      dots: true,
    });
    
    $(".sidebar_carousel2").owlCarousel({
      rtl: true,
      loop: true,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      center: true,
      items:1,
      stagePadding: 90,
      margin: 40,
      responsive: {
        0: {
          items: 1,
        },
        600: {
          items: 3,
        },
        1000: {
          items: 1
        }
      }
    });

    $(".count_carousel").owlCarousel({
      items: 1,
      rtl: true,
      loop: false,
      autoplay: true,
      nav: false,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: true,

    });


// 
    
    $(".single_cast_default").owlCarousel({
      items: 6,
      margin: 24,
      rtl: true,
      loop: false,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 3,
        },
        600: {
          items: 6,
        },
        1000: {
          items: 10,
        }
      }
    });

    $(".single_cast").owlCarousel({
      items: 6,
      margin: 24,
      rtl: true,
      loop: false,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 3,
        },
        600: {
          items: 4,
        },
        1000: {
          items: 6,
        }
      }
    });



    
    $(".lists_carousel").owlCarousel({
      items: 3,
      margin: 10,
      rtl: true,
      loop: false,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 1,
        },
        600: {
          items: 2,
        },
        1000: {
          items: 2,
        },
        1200: {
          items: 3,
        }
      }
    });

    $(".lists_carousel2").owlCarousel({
      items: 3,
      margin: 10,
      // rtl: true,
      loop: false,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 1,
        },
        600: {
          items: 2,
        },
        1000: {
          items: 3,
        },
        1200: {
          items: 5,
        }
      }
    });

    $(".film_cat_carousel").owlCarousel({
      items: 6,
      margin: 20,
      stagePadding:30,
      rtl: true,
      loop: false,
      autoplay: false,
      nav: false,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 2,
        },
        600: {
          items: 3,
        },
        1000: {
          items: 5,
        },
        1200: {
          items: 6,
        }
      }
    });

    $(".film_cat_carousel_panel").owlCarousel({
      items: 8,
      margin: 20,
      // rtl: true,
      loop: false,
      autoplay: false,
      nav: false,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 2,
        },
        600: {
          items: 3,
        },
        1200: {
          items: 6,
        },
        1600: {
          items: 8,
        }
      }
    });


    $(".film_cat_carousel_big").owlCarousel({
      items: 5,
      margin: 20,
      rtl: true,
      stagePadding:30,
      loop: false,
      autoplay: false,
      nav: false,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 2,
        },
        600: {
          items: 2,
        },
        1000: {
          items: 4,
        },
        1200: {
          items: 5,
        }
      }
    });

    $(".rel_posts").owlCarousel({
      items: 5,
      margin: 10,
      rtl: true,
      loop: false,
      autoplay: false,
      nav: true,
      navText : ["<div class='slider_actions'><i class='fa fa-chevron-right'></i></div>","<div class='slider_actions'><i class='fa fa-chevron-left'></i></div>"],
      dots: false,
      responsive: {
        0: {
          items: 2,
        },
        600: {
          items: 4,
        },
        1000: {
          items: 5,
        }
      }
    });



    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl)
    })


  });

  $(function () {
    $("input:radio[name='post-type']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_1"]').text($('input[value="' + firstName + '"]').parent().text());
    });
    $("input:radio[name='post-type']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_1"]').text($('input[value="' + firstName + '"]').parent().text());
    });
    $("input:radio[name='sort']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_3"]').text($('input[value="' + firstName + '"]').parent().text());
    });
    $("input:radio[name='fromYear']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_4"]').text(firstName);
    });
    $("input:radio[name='toYear']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_5"]').text(firstName);
    });
    $("input:radio[name='_country']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_6"]').text($('input[value="' + firstName + '"]').parent().text());
    });
    $("input:radio[name='_rates']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_7"]').text($('input[value="' + firstName + '"]').parent().text());
    });
    $("input:radio[name='_score']").change(function () {
      var firstName = this.value;
      $('a[href="#search_filter_8"]').text($('input[value="' + firstName + '"]').parent().text());
    });
  });


  $('.series_week__header li[data-day]').click(function (e) {
    var element = $(this);
    var selectedDay = element.attr('data-day');
    $.ajax({
      url: ajaxurl,
      data: {
        action: 'loadSeries',
        day: selectedDay,
        nonce: nonce,
      },
      type: 'POST',
      beforeSend: function (xhr) {
        $(".series_week__header li").removeClass("active");
        $('.series_inner').html('<span class="loading"><div class="loader"></div></span>');
        element.addClass('active');
      },
      success: function (data) {
        if (data) {
          $('.series_inner').html(data);
          if (data.error) {
            $('.series_inner').html('<div class="row"><span class="not_found">' + data.message + '</span></div>');
          }
        }
      }
    });

  });
})(jQuery);