<?php if(!isset($args['archive'])): ?>
  <div class="container">
<?php else: ?>
  <div class="mt-4 mb-4">
<?php endif;  ?>
<?php
  $post_type = get_terms(
    array(
      'taxonomy'   => 'type_of_post',
      'hide_empty' => false
    )
  );
  $genres = get_terms(
    array(
      'taxonomy'   => 'genre',
      'hide_empty' => false
    )
  );
  $years = get_terms(
    array(
      'taxonomy'   => 'yearr',
      'hide_empty' => false
    )
  );
  $country = get_terms(
    array(
      'taxonomy'   => 'country',
      'hide_empty' => false
    )
  );
  $rates = get_terms(
    array(
      'taxonomy'   => 'rate',
      'hide_empty' => false
    )
  );
  $scores = get_terms(
    array(
      'taxonomy'   => 'score',
      'hide_empty' => false
    )
  );
?>
<form class="new_advanced_search" method="get" role="search" action="<?php echo esc_url(home_url('/')); ?>">

  <input type="hidden" name="search" value="advanced">
  <input type="hidden" name="s" value="">

  <?php 
  if (isset($_REQUEST['post-type'])) :
    $type_s = esc_sql($_REQUEST['post-type']);
  endif;
  ?>
  <div class="search_type d-flex">
    <span class="<?php echo !isset($type_s) || $type_s == 'all' ? 'active': '' ?>" data-value="all"><?php _e('همه', 'kelaketfilm'); ?></span>
    <?php foreach($post_type as $type): ?>
    <span class="<?php echo isset($type_s) && $type_s == $type->slug ? 'active': '' ?>" data-value="<?php echo $type->slug ?>"><?php _e($type->name, 'kelaketfilm'); ?></span>
    <?php endforeach; ?>
    <input id="adv_post-type" type="hidden" name="post-type" value="all">
  </div>

  <?php 
  if (isset($_REQUEST['_genre'])) :
    $genre_s = esc_sql($_REQUEST['_genre']);
  endif;
  ?>
  <div class="d-flex align-items-center">
    <small class="adv_search_badge"><?php _e('ژانر', 'kelaketfilm'); ?></small>
    <select class="ns_select" name="_genre">
      <option data-display="<?php _e('ژانر', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
      <?php foreach($genres as $genre): ?>
      <option <?php if (!empty($genre_s) && $genre->slug ==  $genre_s) {echo 'selected="selected"';} ?>  value="<?php echo $genre->slug ?>"><?php _e($genre->name, 'kelaketfilm'); ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <?php
    if (isset($_REQUEST['doble'])) :
      $doble_s = esc_sql($_REQUEST['doble']);
    else :
      $doble_s = null;
    endif;
    if (isset($_REQUEST['subtitle'])) :
      $subtitle_s = esc_sql($_REQUEST['subtitle']);
    else :
      $subtitle_s = null;
    endif;
    if (isset($_REQUEST['playonline'])) :
      $playonline_s = esc_sql($_REQUEST['playonline']);
    else :
      $playonline_s = null;
    endif;
  ?>

  <div class="switch-toggle">
    <small><?php _e('دوبله فارسی', 'kelaketfilm'); ?></small>
		<label>
		  <input
      <?php if (!empty($doble_s)) {
        echo 'checked';
      } ?> name="doble" type="checkbox">
		  <span></span>
		</label>
	</div>

  <div class="switch-toggle">
    <small><?php _e('زیرنویس فارسی', 'kelaketfilm'); ?></small>
		<label>
		  <input
      <?php if (!empty($subtitle_s)) {
        echo 'checked';
      } ?> name="subtitle"
      type="checkbox">
		  <span></span>
		</label>
	</div>

  <div class="switch-toggle">
    <small><?php _e('پخش آنلاین', 'kelaketfilm'); ?></small>
		<label>
		  <input
      <?php if (!empty($playonline_s)) {
        echo 'checked';
      } ?> name="playonline"
      type="checkbox">
		  <span></span>
		</label>
	</div>

  
  <button class="adv_more_filters" type="button">
    <?php _e('فیلتر های بیشتر', 'kelaketfilm'); ?>
    <i class="fa fa-bars-filter"></i>
  </button>

  <input class="adv_search_submit" type="submit"  value="<?php _e('جستجو', 'kelaketfilm'); ?>" />


  <?php 
  if (isset($_REQUEST['_country'])) :
    $country_s = esc_sql($_REQUEST['_country']);
  endif;
  ?>

  <div id="adv_search_more" tabindex="0">
    <div>
      <select class="ns_select" name="_country">
        <option data-display="<?php _e('کشور سازنده', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($country as $ctry): ?>
        <option <?php if (!empty($country_s) && $ctry->slug == $country_s) {echo 'selected="selected"';} ?> value="<?php echo $ctry->slug ?>"><?php _e($ctry->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <?php 
    if (isset($_REQUEST['fromYear'])) :
      $fromYear_s = esc_sql($_REQUEST['fromYear']);
    endif;

    if (isset($_REQUEST['toYear'])) :
      $toYear_s = esc_sql($_REQUEST['toYear']);
    endif;
    ?>

    <div class="year_range d-flex">
      <div class="d-flex align-items-center">
        <small><?php _e('از سال', 'kelaketfilm'); ?></small>
        <select class="ns_select"  name="fromYear">
          <option data-display="<?php _e('انتخاب کنید', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
          <?php foreach($years as $year): ?>
          <option <?php if (!empty($fromYear_s) && $year->slug == $fromYear_s) {echo 'selected="selected"';} ?> value="<?php echo $year->slug ?>"><?php _e($year->name, 'kelaketfilm'); ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="d-flex align-items-center">
      <small><?php _e('تا سال', 'kelaketfilm'); ?></small>

        <select class="ns_select"  name="toYear">
          <option data-display="<?php _e('انتخاب کنید', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
          <?php foreach($years as $year): ?>
          <option <?php if (!empty($toYear_s) && $year->slug == $toYear_s) {echo 'selected="selected"';} ?> value="<?php echo $year->slug ?>"><?php _e($year->name, 'kelaketfilm'); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div>
      <select class="ns_select"  name="sort">
        <option data-display="<?php _e('نمایش بر اساس', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <option value="newest"><?php _e('جدید ترین ها', 'kelaketfilm'); ?></option>
        <option value="oldest"><?php _e('قدیمی ترین ها', 'kelaketfilm'); ?></option>
      </select>
    </div>

    <?php 
    if (isset($_REQUEST['_rates'])) :
      $rates_s = esc_sql($_REQUEST['_rates']);
    endif;
    ?>
    <div>
      <select class="ns_select"  name="_rates">
        <option data-display="<?php _e('رده سنی', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($rates as $rate): ?>
          <option <?php if (!empty($rates_s) && $rate->slug == $rates_s) {echo 'selected="selected"';} ?> value="<?php echo $rate->slug ?>"><?php _e($rate->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <?php 
    if (isset($_REQUEST['_score'])) :
      $score_s = esc_sql($_REQUEST['_score']);
    endif;
    ?>

    <div>
      <select class="ns_select"  name="_score">
        <option data-display="<?php _e('امتیاز imdb', 'kelaketfilm'); ?> " value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($scores as $score): ?>
          <option <?php if (!empty($score_s) && $score->slug == $score_s) {echo 'selected="selected"';} ?> value="<?php echo $score->slug ?>"><?php _e($score->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    
  </div>

</form>



<button class="mobile_adv_trigger">
  <i class="fa fa-chevron-down toggle_status"></i>
  <?php _e('جستجوی پیشرفته', 'kelaketfilm'); ?>
  <i class="fa fa-bars-filter filter_icon"></i>
</button>

<div id="mobile_adv_search">
  <div class="mobile_adv_search__header">
    <h3><?php _e('جستجوی پیشرفته', 'kelaketfilm'); ?></h3>
    <button class="mobile_adv_search_close"><i class="fa fa-xmark"></i></button>
  </div>
  <form method="get" role="search" action="<?php echo esc_url(home_url('/')); ?>">

  <input type="hidden" name="search" value="advanced">
  <input type="hidden" name="s" value="">

  <div class="d-flex align-items-center mb-3">
    <select class="ns_select wide" name="post-type">
      <option data-display="<?php _e('نوع', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
      <option <?php if (!empty($type_s) && $type->slug ==  $type_s) {echo 'selected="selected"';} ?> value="all"><?php _e('همه', 'kelaketfilm'); ?></option>
      <?php foreach($post_type as $type): ?>
      <option <?php if (!empty($type_s) && $type->slug ==  $type_s) {echo 'selected="selected"';} ?> value="<?php echo $type->slug ?>"><?php _e($type->name, 'kelaketfilm'); ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="d-flex align-items-center mb-3">
    <select class="ns_select wide" name="_genre">
      <option data-display="<?php _e('ژانر', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
      <?php foreach($genres as $genre): ?>
      <option <?php if (!empty($genre_s) && $genre->slug ==  $genre_s) {echo 'selected="selected"';} ?> value="<?php echo $genre->slug ?>"><?php _e($genre->name, 'kelaketfilm'); ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="d-flex align-items-center mb-3">
    <div class="nice-box">
      <small><?php _e('دوبله فارسی', 'kelaketfilm'); ?></small>
      <div class="switch-toggle">
        <label>
          <input
          <?php if (!empty($doble_s)) {
            echo 'checked';
          } ?> name="doble" type="checkbox">
          <span></span>
        </label>
      </div>
    </div>
  </div>

  <div class="d-flex align-items-center mb-3">
    <div class="nice-box">
      <small><?php _e('زیرنویس فارسی', 'kelaketfilm'); ?></small>
      <div class="switch-toggle">
        <label>
          <input
          <?php if (!empty($playonline_s)) {
            echo 'checked';
          } ?> name="playonline"
          type="checkbox">
          <span></span>
        </label>
      </div>
    </div>
  </div>

  <div class="d-flex align-items-center mb-3">
    <div class="nice-box">
      <small><?php _e('پخش آنلاین', 'kelaketfilm'); ?></small>
      <div class="switch-toggle">
        <label>
          <input
          <?php if (!empty($playonline_s)) {
            echo 'checked';
          } ?> name="playonline"
          type="checkbox">
          <span></span>
        </label>
      </div>
    </div>
  </div>

  <div class="d-flex align-items-center mb-3">
      <select class="ns_select wide"  name="_country">
        <option data-display="<?php _e('کشور سازنده', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($country as $ctry): ?>
        <option <?php if (!empty($country_s) && $ctry->slug == $country_s) {echo 'selected="selected"';} ?> value="<?php echo $ctry->slug ?>"><?php _e($ctry->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="year_range d-flex mb-3 gap-3">
        <select class="ns_select wide"  name="fromYear">
          <option data-display="<?php _e('از سال', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
          <?php foreach($years as $year): ?>
          <option <?php if (!empty($fromYear_s) && $year->slug == $fromYear_s) {echo 'selected="selected"';} ?> <?php if (!empty($toYear_s) && $year->slug == $toYear_s) {echo 'selected="selected"';} ?> value="<?php echo $year->slug ?>"><?php _e($year->name, 'kelaketfilm'); ?></option>
          <?php endforeach; ?>
        </select>

        <select class="ns_select wide"  name="toYear">
          <option data-display="<?php _e('تا سال', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
          <?php foreach($years as $year): ?>
          <option <?php if (!empty($toYear_s) && $year->slug == $toYear_s) {echo 'selected="selected"';} ?> value="<?php echo $year->slug ?>"><?php _e($year->name, 'kelaketfilm'); ?></option>
          <?php endforeach; ?>
        </select>
    </div>

    <div class="d-flex align-items-center mb-3">
      <select class="ns_select wide"  name="sort">
        <option data-display="<?php _e('نمایش بر اساس', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <option value="newest"><?php _e('جدیدترین ها', 'kelaketfilm'); ?></option>
        <option value="oldest"><?php _e('قدیمی ترین ها', 'kelaketfilm'); ?></option>
      </select>
    </div>

    <div class="d-flex align-items-center mb-3">
      <select class="ns_select wide"  name="_rates">
        <option data-display="<?php _e('رده سنی', 'kelaketfilm'); ?>" value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($rates as $rate): ?>
          <option <?php if (!empty($rates_s) && $rate->slug == $rates_s) {echo 'selected="selected"';} ?> value="<?php echo $rate->slug ?>"><?php _e($rate->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="d-flex align-items-center mb-3">
      <select class="ns_select wide"  name="_score">
        <option data-display="<?php _e('امتیاز imdb', 'kelaketfilm'); ?> " value=""><?php _e('انتخاب کنید', 'kelaketfilm'); ?></option>
        <?php foreach($scores as $score): ?>
          <option <?php if (!empty($score_s) && $score->slug == $score_s) {echo 'selected="selected"';} ?> value="<?php echo $score->slug ?>"><?php _e($score->name, 'kelaketfilm'); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

  <input class="mobile_adv_submit" type="submit" value="<?php _e('جستجو', 'kelaketfilm'); ?>">
  </form>
</div>
</div>