<?php
/* Template Name: لیست بازیگران*/
get_header();
?>
<main class="container after_fe2 actors_page">
  <div class="content__header d-flex justify-content-between pt-3 mt-5 mb-3">
    <h1><?php _e('لیست بازیگران', 'kelaketfilm') ?></h1>
  </div>
  <div class="actor_search text-center mb-5">
    <form method="get">
      <div class="search_input_wrap">
        <input class="search_input" type="text" name="search" value="<?php echo isset($_GET['search']) ? $_GET['search'] : '' ?>" placeholder="<?php _e('نام بازیگر را وارد کنید...', 'kelaketfilm'); ?>">
        <button class="search_submit" type="submit"><?php _e('جست‌و‌جو', 'kelaketfilm'); ?> <i class="fa fa-search"></i></button>
      </div>
    </form>
  </div>
  <div class="row">
  <?php 
  $taxonomy = 'actor';
  $s = '';
  if(isset($_GET['search']) && !empty($_GET['search'])){
    $s = $_GET['search'];
  }
  $number   = 24;
  $page         = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
  $offset       = ( $page > 0 ) ?  $number * ( $page - 1 ) : 1;
  $totalterms   = wp_count_terms( $taxonomy, array( 'hide_empty' => false, 'name__like' => $s ) ); 
  $totalpages   = ceil( $totalterms / $number );

  $artists = get_terms($taxonomy,array('hide_empty' => false, 'number' => $number, 'offset' => $offset, 'name__like' => $s));
  foreach($artists as $artist):?>
    <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-3 col-sm-3 col-6">
      <div class="postItem">
        <div class="postItem_image">
          <a href="<?php bloginfo('url');?>/actor/<?= $artist->slug ?>">
          <?php if(get_field('actor_image_link', $artist)){ ?>
            <img width="169" height="169" src="<?php echo get_field('actor_image_link', $artist) ?>" alt="<?= $artist->name ?>" title="<?= $artist->name ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';"/>
          <?php }else{ ?>
            <img width="169" height="169" src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="<?php single_cat_title(); ?>" />
          <?php } ?>
          </a>
        </div>
        <div class="postItem_title text-center">
          <a href="<?php bloginfo('url');?>/actor/<?= $artist->slug ?>">
            <h2><?= $artist->name ?></h2>
          </a>
        </div>
      </div>
    </div>
  <?php endforeach;?>
    
  </div>
  <div class="pagination">
  <?php
    echo paginate_links(array(
      'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
      'total' => $totalpages,
      'current' => max(1, get_query_var('paged')),
      'format' => '?paged=%#%',
      'show_all' => false,
      'type' => 'plain',
      'end_size' => 2,
      'mid_size' => 1,
      'prev_next' => true,
      'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
      'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
      'add_args' => false,
      'add_fragment' => '',
    ));
    ?>
  </div>
</main>


<?php get_footer(); ?>