<?php
/* Template Name: Mobile Auth Page*/
global $wpdb, $user_ID, $wp;
$current = $wp->request;
$config = get_option('my_framework');
?>
<title><?php bloginfo('name') ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
<!-- Bootstrap core CSS -->
<?php if (theme_options('favicon')['url']) : ?>
  <link rel="icon" type="image" href="<?php echo theme_options('favicon')['url']; ?> " />
<?php else : ?>
  <link rel="icon" type="image" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" />
<?php endif; ?>
<?php wp_head(); ?>
<style>
  #mobile_auth_2 {
    display: none;
  }

  .toast-success {
    background-color: #10d876 !important;
    opacity: 1 !important;
  }

  .toast-warning {
    background-color: #ff8f00 !important;
    opacity: 1 !important;
  }

  .toast-error {
    background-color: #b2102f !important;
    opacity: 1 !important;
  }
</style>

<?php
if (!$user_ID) { ?>
  <div style="direction: <?php echo is_rtl() ? 'rtl' : 'ltr' ?>;" class="register">
    <div class="manual-register-form">
      <div class="logo">
        <a href="<?php bloginfo('url') ?>">
          <?php if (theme_options('logo_image')['url']) : ?>
            <img src="<?php echo theme_options('logo_image')['url']; ?>" alt="logo" class="logo_img" />
          <?php else : ?>
            <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
          <?php endif; ?>
          <span><?php echo theme_options('logo_text'); ?></span>
        </a>
      </div>
      <div class="title">
        <h2><?php _e('ورود / ثبت نام', 'kelaketfilm'); ?></h2>
      </div>
      <form id="mobile_auth" method="post" class="rcp_login_data">
        <input type="tel" name="phone" placeholder="<?php _e('شماره موبایل خود را وارد کنید', 'kelaketfilm'); ?>" class="register-input" />
        <input type="submit" id="mobile_auth_submit" class="submit-reg" name="submit" value="<?php _e('ورود / ثبت نام', 'kelaketfilm'); ?>" />
      </form>
      <form id="mobile_auth_2" method="post" class="rcp_login_data otp-form">
        <p>
          <label for="otp" id="phone_wraper"></label>

        <div class="d-flex gap-2 ltr">
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
          <input class="otp-field" type="text" name="opt-field[]" maxlength=1>
        </div>
        <!-- Store OTP Value -->
        <input class="otp-value" type="hidden" name="opt-value">

        <div class="d-flex otp_cta gap-2">
          <input type="submit" id="mobile_auth_submit2" class="submit_auth_2" name="submit" value="<?php _e('بررسی کد', 'kelaketfilm'); ?>" />
          <input type="button" id="mobile_auth_again" class="submit_auth_2" name="submit" value="<?php _e('ارسال دوباره', 'kelaketfilm'); ?>" disabled="disabled" />
        </div>

        </p>
        <!-- <p class="text-center">
          <input type="numeric" inputmode="numeric" autocomplete="one-time-password" name="otp" class="register-input" />
        </p> -->

      </form>
      <p class="text-center"><a href="<?php bloginfo('url') ?>/login"><?php _e('ورود با ایمیل/نام کاربری', 'kelaketfilm'); ?></a></p>
    </div>
  </div>

  <input type="hidden" id="phone_temp" value="">
  <script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/js/toastr.min.js"></script>
  <script>
    $(document).ready(function() {
      $(".otp-form *:input[type!=hidden]:first").focus();
      let otp_fields = $(".otp-form .otp-field"),
        otp_value_field = $(".otp-form .otp-value");
      otp_fields
        .on("input", function(e) {
          $(this).val(
            $(this)
            .val()
            .replace(/[^0-9]/g, "")
          );
          let opt_value = "";
          otp_fields.each(function() {
            let field_value = $(this).val();
            if (field_value != "") opt_value += field_value;
          });
          otp_value_field.val(opt_value);
        })
        .on("keyup", function(e) {
          let key = e.keyCode || e.charCode;
          if (key == 8 || key == 46 || key == 37 || key == 40) {
            // Backspace or Delete or Left Arrow or Down Arrow
            $(this).prev().focus();
          } else if (key == 38 || key == 39 || $(this).val() != "") {
            // Right Arrow or Top Arrow or Value not empty
            $(this).next().focus();
          }
        })
        .on("paste", function(e) {
          let paste_data = e.originalEvent.clipboardData.getData("text");
          let paste_data_splitted = paste_data.split("");
          $.each(paste_data_splitted, function(index, value) {
            otp_fields.eq(index).val(value);
          });
        });
    });

    function startTimer(duration, display) {
      var timer = duration,
        minutes, seconds;
      inter = setInterval(function() {
        minutes = parseInt(timer / 60, 10);
        seconds = parseInt(timer % 60, 10);

        minutes = minutes < 10 ? "0" + minutes : minutes;
        seconds = seconds < 10 ? "0" + seconds : seconds;

        display.value = minutes + ":" + seconds;

        if (--timer < 0) {
          //clear interval to stor timer
          clearInterval(inter);
          display.value = 'ارسال دوباره';
          display.disabled = false;
        }
      }, 1000);
    }

    $("#mobile_auth").submit(function(event) {
      event.preventDefault();
      var mobileNumber = event.target[0].value;
      $("#phone_temp").val(mobileNumber);
      if (mobileNumber.length < 1) {
        toastr.warning('شماره موبایل خود را وارد کنید!');
      } else if (mobileNumber.length < 10 || mobileNumber.length > 11) {
        toastr.warning('شماره موبایل وارد شده صحیح نمی‌باشد.');
      } else if (mobileNumber.match(/[a-z]/i)) {
        toastr.warning('شماره موبایل وارد شده صحیح نمی‌باشد.');
      } else {
        var sendButton = $('#mobile_auth_submit');
        // console.log(sendButton.val('12'));
        $('#mobile_auth_submit').val('صبرکنید...')
        $('#mobile_auth_submit').attr("disabled", true);
        $.post("/wp-json/mobile/v1/auth", {
            phone: mobileNumber,
            web: true
          },
          function(data, status) {
            console.log(data, status);
            if (data.code == 201) {
              $('#mobile_auth_submit').val('ورود / ثبت نام')
              $('#mobile_auth_submit').attr("disabled", false);
              $('#mobile_auth').hide();
              $('#phone_wraper').text(" کد تایید برای  شماره" + mobileNumber + " ارسال شد.");
              $('#mobile_auth_2').show();
              display = document.querySelector('#mobile_auth_again');
              startTimer(120, display);
            } else {
              console.log(data, status);
              toastr.error('مشکلی پیش آمد دوباره تلاش کنید.')
            }
          });
      }
    });

    $('#mobile_auth_again').click(function() {
      var mobileNumber = $("#phone_temp").val();
      $.post("/wp-json/mobile/v1/auth", {
          phone: mobileNumber,
        },
        function(data, status) {
          console.log(data, status);
          if (data.code == 201) {
            toastr.success('کد مجددا برای شما ارسال شد!');
            display = document.querySelector('#mobile_auth_again');
            display.disabled = true;
            startTimer(120, display);
          } else {
            toastr.error('مشکلی پیش آمد دوباره تلاش کنید.')
          }
        });

    });



    $("#mobile_auth_2").submit(function(event) {
      event.preventDefault();
      var code = $('.otp-value').val();
      console.log('code', code);
      var mobileNumber = $("#phone_temp").val();
      $('#mobile_auth_submit2').val('صبرکنید...');
      $('#mobile_auth_submit2').attr("disabled", true);


      if (code.length < 1) {
        toastr.warning('کد دریافتی را وارد کنید.');
        $('#mobile_auth_submit2').attr("disabled", false);
        $('#mobile_auth_submit2').val('بررسی کد');
      } else if (code.length < 6 || code.length > 6) {
        toastr.warning('فرمت کد وارد شده صحیح نمی‌باشد.');
        $('#mobile_auth_submit2').attr("disabled", false);
        $('#mobile_auth_submit2').val('بررسی کد');
      } else {
        $.post("/wp-json/mobile/v1/auth", {
            phone: mobileNumber,
            user_otp: code,
            web: true
          },
          function(data, status) {
            console.log(data);
            if (data.code == 200) {
              $('#mobile_auth_submit2').val('بررسی کد')
              $('#mobile_auth_submit2').attr("disabled", true);
              toastr.success('ورود موفقیت آمیز بود.');
              window.location.href = data.redirect;
            } else {
              $('#mobile_auth_submit2').val('بررسی دوباره کد')
              $('#mobile_auth_submit2').attr("disabled", false);
              toastr.error(data.message)
            }
          });
      }
    });
  </script>
<?php } else { ?>
  <a href="<?php bloginfo('url'); ?>">برو خانه</a>
<?php } ?>