<?php
/* Template Name: صفحه اختصاصی باکس آفیس */
?>
<?php get_header(); ?>
<div class="container after_fe2">
  <div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 col-xxl-12">
      <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
          <article class="boxOffice_page mb-5">
            <div class="row">
              <div class="post_details post_page col-lg-12 col-md-12">
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <?php the_content(); ?>

                <?php if (get_field('boxOffice_type') == 'auto') : ?>
                  <div class="boxOfficeWrap row g-3">
                    <?php get_template_part('inc/template_parts/box_office',null,array('type'=> get_field('boxOffice_data'))) ?>
                  </div>
                <?php endif; ?>

                <?php if (get_field('boxOffice') && get_field('boxOffice_type') == 'manual') : ?>
                  <div class="boxOfficeWrap row g-3">
                    <?php if (have_rows('boxOffice')) {
                      $rank = 1;
                      while (have_rows('boxOffice')) : the_row();
                        $id = get_sub_field('film')->ID;
                    ?>
                        <div class="col-xxl-3 col-xl-4 col-lg-4 col-sm-6">
                          <a href="<?php the_permalink($id); ?>">
                            <div class="boxOffice_item d-flex">
                              <div class="boxOffice_image">
                                <?= get_the_post_thumbnail($id, 'post-cat-thumb'); ?>
                                <span class="rank"><?= $rank ?></span>
                              </div>
                              <div class="boxOffice__meta px-2">
                                <ul class="d-flex flex-column">
                                  <li>
                                    <h3><?= get_sub_field('film')->post_title; ?></h3>
                                  </li>
                                  <li><?php _e('کارگردان', 'kelaketfilm') ?>:‌ <?= get_the_term_list($id, 'director', '', '، ', '') ?></li>
                                  <li><?php _e('مدت اکران', 'kelaketfilm') ?>:‌ <?= get_sub_field('time') ?></li>
                                  <li><?php _e('میزان فروش', 'kelaketfilm') ?>:‌ <?= get_sub_field('sale'); ?></li>
                                </ul>
                              </div>
                            </div>
                          </a>
                        </div>
                    <?php $rank++;
                      endwhile;
                    } ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </article>
          <?php endwhile;
      else : the_content(); ?><?php endif; ?>
    </div>
  </div>
</div>


<?php get_footer(); ?>