<?php
/* Template Name: صفحه اختصاصی فیلم هایی که در آینده منتشر خواهند شد. */
get_header();
?>
<main class="container after_fe2 actors_page">
  <div class="content__header text-center pt-3 mt-5 mb-5">
    <h1><?php _e('فیلم هایی که بزودی منتشر خواهند شد', 'kelaketfilm') ?></h1>
    <p class="mt-3"><?php _e('فیلم هایی که بزودی منتشر خواهند شد به همراه تایمر انتشار', 'kelaketfilm'); ?></p>
  </div>
 
  <div class="row">
    <?php 
    if(get_comingsoon()):
      // $data = get_imdb_250_movies()['data'];
      $data = array_chunk(get_comingsoon()['data'], 42);
      $pagenum = (get_query_var('paged')) ? (get_query_var('paged') - 1) : 0;
      $limit = 42;
      $num_of_pages = ceil(count(get_comingsoon()['data']) / $limit);
    
      foreach ($data[$pagenum] as $index => $item ): 
      ?>
      <div class="col-lg-2 col-md-3 col-sm-6 col-6">
        <div class="film_cat film_cat2 film_cat_imdb film_cat_soon">
          <a href="<?php echo site_url(). '/?imdb_id='. $item['id']; ?>">
            <div class="position-relative">
              <img width="196" height="280" src="<?php echo kelaket_is_url($item['image'], $item['id']) ?>" alt="<?php echo $item['title'] ?>">
              <div class="film_timer">
                <?php $date = date('Y-m-d', strtotime($item['rel_date'])); ?>
                <div class="countdown show" data-endText="<?php _e('منتشر شد', 'kelaketfilm'); ?>" data-Date='<?php echo $date; ?>'>
                  <div class="running">
                    <div class="timer">
                      <div>
                        <span class="days"></span>
                        <div class="counter_label"><?php _e('روز', 'kelaketfilm'); ?></div>
                      </div>
                      <div>
                        <span class="hours"></span>
                        <div class="counter_label"><?php _e('ساعت', 'kelaketfilm'); ?></div>
                      </div>
                      <div>
                        <span class="minutes"></span>
                        <div class="counter_label"><?php _e('دقیقه', 'kelaketfilm'); ?></div>
                      </div>
                      <div>
                        <span class="seconds"></span>
                        <div class="counter_label"><?php _e('ثانیه', 'kelaketfilm'); ?></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="film_cat_title ltr"><?php echo $item['full_title']; ?></div>
          </a>
        </div>
      </div>
    <?php endforeach;?>
    <?php endif; ?>

    
    <div class="pagination">
      <?php
      echo paginate_links(array(
        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'total' => $num_of_pages,
        'current' => max(1, get_query_var('paged')),
        'format' => '?paged=%#%',
        'show_all' => false,
        'type' => 'plain',
        'end_size' => 4,
        'mid_size' => 1,
        'prev_next' => true,
        'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
        'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
        'add_args' => false,
        'add_fragment' => '',
      ));
      ?>
    </div>

  </div>
</main>


<?php get_footer(); ?>