<?php
/* Template Name: صفحه اختصاصی ۲۵۰ فیلم برتر imdb*/
get_header();
?>
<main class="container after_fe2 actors_page">
  <div class="content__header text-center pt-3 mt-5 mb-5">
    <h1><?php _e('لیست ۲۵۰ فیلم برتر IMDB', 'kelaketfilm') ?></h1>
    <p class="mt-3"><?php _e('لیستی از ۲۵۰ فیلم برتر به انتخاب سایت IMDB', 'kelaketfilm'); ?></p>
  </div>
 
  <div class="row">
    <?php 
    if(get_imdb_250_movies()):
      // $data = get_imdb_250_movies()['data'];
      $data = array_chunk(get_imdb_250_movies()['data'], 42);
      $pagenum = (get_query_var('paged')) ? (get_query_var('paged') - 1) : 0;
      $limit = 42;
      $num_of_pages = ceil(count(get_imdb_250_movies()['data']) / $limit);
    
      foreach ($data[$pagenum] as $item): 
      ?>
      <div class="col-lg-2 col-md-3 col-sm-6 col-6">
        <div class="film_cat film_cat2 film_cat_imdb">
          <a href="<?php echo site_url(). '/?imdb_id='. $item['id']; ?>">
            <div class="position-relative">
              <?php 
              
              //var_dump( kelaket_is_url($item['image']) ); ?>
              <img width="196" height="280" src="<?php echo kelaket_is_url($item['image'], $item['id']) ?>" alt="<?php echo $item['title'] ?>">
              <div class="film_overlay">
                <span class="dobed"><?php echo $item['rank']; ?></span>
              </div>
              <?php if ($item['imdb_rate']) :
                $imdb_color = 'score_green';
                if ((int) $item['imdb_rate'] < 5) {
                  $imdb_color = 'score_danger';
                } elseif ((int) $item['imdb_rate'] < 7 && (int) $item['imdb_rate'] > 5) {
                  $imdb_color = 'score_warn';
                }
              ?>
                <div class="imdb_score_circle <?php echo $imdb_color ? $imdb_color : '' ?>">
                  <?php echo $item['imdb_rate']; ?>
                </div>
              <?php endif; ?>
            </div>
            <div class="film_cat_title ltr"><?php echo $item['title']; ?></div>
          </a>
        </div>
      </div>
    <?php endforeach;?>
    <?php endif; ?>

    
    <div class="pagination">
      <?php
      echo paginate_links(array(
        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'total' => $num_of_pages,
        'current' => max(1, get_query_var('paged')),
        'format' => '?paged=%#%',
        'show_all' => false,
        'type' => 'plain',
        'end_size' => 4,
        'mid_size' => 1,
        'prev_next' => true,
        'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
        'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
        'add_args' => false,
        'add_fragment' => '',
      ));
      ?>
    </div>

  </div>
</main>


<?php get_footer(); ?>