<?php
/* Template Name: صفحه اختصاصی نمایش لیست کاربران */
$config = get_option('my_framework');
get_header(); ?>

<div class="container after_fe2">
  <div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 col-xxl-12">
      <?php
        $list_id = get_query_var('id') ? get_query_var('id') : '';
        if(is_page('lists') && !empty($list_id)){
          global $wpdb;
          $tablename = $wpdb->prefix . 'kelaket_lists';
          $qry = "select * from $tablename WHERE id = $list_id LIMIT 1";
          $result = $wpdb->get_results($qry);

          $list_name = $result[0]->name;
          $list_desc = $result[0]->list_desc;
          $list_user = $result[0]->user_id;
          $update_date = $result[0]->updated_at;
          $is_private = $result[0]->is_private;
          $user = get_user_by('id', $list_user);

          //check list is private then decide to show page to current user or not 
          if($is_private){
            if($list_user == get_current_user_id()){
            }else{
              die(__('این لیست خصوصی میباشد و شما امکان مشاهده آن را ندارید.', 'kelaketfilm'));
            }
          }

          $page_title = $list_name .'<small>'. __(' ساخته شده توسط', 'kelaketfilm').'   '. $user->display_name.'</small>';
        }else{
          $page_title = __('تمامی لیست های کاربران', 'kelaketfilm');
        }
      ?>
        <div class="category_title">
          <h3>
            <i class="fa fa-list"></i>
            <?php echo $page_title; ?>
            <?php if(isset($list_desc)): ?>
              <div class="taxonomy-description">
                <p><?php echo $list_desc; ?></p>
              </div>
            <?php endif;?>
          </h3>
        </div>
      <?php
        if(is_page('lists') && !empty($list_id)){
          // load list detail page
          get_template_part('inc/template_parts/lists/single_lists', null, array('user_id' => $list_user));
        }else{
          // load all lists page
          get_template_part('inc/template_parts/lists/all_lists');
        }?>
    </div>
  </div>
</div>


<?php get_footer(); ?>