<?php
/* Template Name: صفحه اختصاصی پنل کاربری */
$config = get_option('my_framework');
$is_loggedin = is_user_logged_in();
$current_user = wp_get_current_user();

if (!$is_loggedin) {
  header('Location: ' . site_url() . '/login');
}
if (empty($_GET['action'])) {
  header('Location: ' . site_url() . '/panel/?action=dashboard');
}
$action = $_GET['action'];
get_header();
?>

<style>
  .header{
    display: none;
  }
</style>

<div class="container-fluid pt-5">
  <aside class="sidebar d-none d-lg-flex">
    <div class="panel_sidebar__header d-flex justify-content-between align-items-center">
      <a href="<?php bloginfo('url') ?>">
        <?php if ($config['logo_image']['url']) : ?>
          <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
        <?php else : ?>
          <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
        <?php endif; ?>
        <span><?php echo $config['logo_text']; ?></span>
      </a>

      <div class="panel_header__btn">
        <button class="d-flex d-lg-none" id="close_panel_nav"><i class="fa fa-x"></i></button>
      </div>
    </div>
    <nav class="nav_panel">
      <ul>
        <li class="<?php echo ($action === 'dashboard') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=dashboard"><i class="fa fa-objects-column"></i><span><?php _e('داشبورد', 'kelaketfilm') ?></span></a></li>
        <?php if ($config['vip']) : ?><li class="<?php echo ($action === 'vip') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=vip"><i class="fa fa-gem"></i><span><?php _e('اشتراک ویژه', 'kelaketfilm') ?></span></a></li><?php endif; ?>
        <li class="has-child <?php echo ($action === 'add_ticket' || $action === 'tickets' || $action === 'show_ticket') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=tickets"><i class="fa fa-ticket"></i><span><?php _e('تیکت های پشتیبانی', 'kelaketfilm') ?></span></a>
            <ul class="sub-menu">
              <li><a href="<?php bloginfo('url') ?>/panel?action=add_ticket"><i class="fa fa-circle-plus"></i> <?php _e('تیکت جدید', 'kelaketfilm') ?></a></li>
              <li><a href="<?php bloginfo('url') ?>/panel?action=tickets"><i class="fa fa-ticket"></i> <?php _e('تیکت ها', 'kelaketfilm') ?></a></li>
            </ul>
          </li>
        <li class="<?php echo ($action === 'watchlist') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=watchlist"><i class="fa fa-bookmark"></i><span><?php _e('لیست تماشا', 'kelaketfilm') ?></span></a></li>
        <li class="<?php echo ($action === 'lists') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=lists"><i class="fa fa-list"></i><span><?php _e('لیست های سفارشی', 'kelaketfilm') ?></span></a></li>
        <li class="<?php echo ($action === 'req') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=req"><i class="fa fa-film"></i><span><?php _e('درخواست فیلم و سریال', 'kelaketfilm') ?></span></a></li>
        <li class="<?php echo ($action === 'editprofile') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=editprofile"><i class="fa fa-pencil"></i><span><?php _e('ویرایش پروفایل', 'kelaketfilm') ?></span></a></li>
        <li class="<?php echo ($action === 'comments') ? 'active' : ''; ?>"><a href="<?php bloginfo('url') ?>/panel?action=comments"><i class="fa fa-comments"></i><span><?php _e('دیدگاه های شما', 'kelaketfilm') ?></span></a></li>
        <li><a href="<?php echo wp_logout_url(site_url()) ?>"><i class="fa fa-arrow-right-from-bracket"></i><span><?php _e('خروج از حساب کاربری', 'kelaketfilm') ?></span></a></li>
      </ul>
    </nav>
    <div class="sidebar_bottom">
      <?php if(function_exists('rcp_user_has_active_membership')):
        if(rcp_user_has_active_membership(get_current_user_id())):
        ?>
        <div class="account_details">
        <?php _e('روز های باقی مانده از اشتراک', 'kelaketfilm') ?>

        <?php if (function_exists('rcp_get_customer_single_membership')) :?>
          <span><?php echo $days_ramain = round((kelaket_get_user_expiration() - time()) / 86400); ?> <?php _e('روز', 'kelaketfilm') ?></span>
        <?php endif; ?>
        </div>
      <?php endif; endif; ?>
      
    <?php
    if( theme_options('vip') ):
      if(function_exists('rcp_user_has_active_membership')):
        if(rcp_user_has_active_membership(get_current_user_id())):?>
          <a href="<?php bloginfo('url') ?>/panel?action=vip" class="sidebar_cta"><?php _e('مشاهده وضعیت اشتراک', 'kelaketfilm') ?></a>
        <?php else:?>
          <a href="<?php bloginfo('url') ?>/panel?action=vip" class="sidebar_cta"><?php _e('خرید اشتراک', 'kelaketfilm') ?></a>
        <?php endif;
      endif;
    endif;
     ?>
    </div>
  </aside>
  <div class="panel_wrapper">
    <div class="row">
      <div class="col-sm-12 gx-5">
        <div class="panel_header mb-5">
          <div class="d-flex justify-content-between">
            <div class="panel_header__user d-flex align-items-center">
              <div class="panel_header__user__avatar">
                <i class="fa fa-user"></i>
              </div>
              <?php echo $current_user->display_name; ?>
            </div>
            <div class="panel_header__btn d-flex gap-3">
              <a data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('ارسال تیکت', 'kelaketfilm') ?>" href="<?php echo bloginfo('url') ?>/panel?action=add_ticket"><i class="fa fa-ticket"></i></a>
              <?php if(theme_options('vip')): ?>
              <a data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('خرید اشتراک', 'kelaketfilm') ?>" href="<?php echo bloginfo('url') ?>/panel?action=vip"><i class="fa fa-gem"></i></a>
              <?php endif; ?>
              <button class="d-flex d-lg-none" id="toggle_panel_nav" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="بازکردن منو"><i class="fa fa-bars"></i></button>
            </div>
          </div>
        </div>    

        <?php
        switch ($action) {
          case "dashboard":
            get_template_part('inc/template_parts/panel/dashboard');
            break;
          case "vip":
            get_template_part('inc/template_parts/panel/vip');
            break;
          case "watchlist":
            get_template_part('inc/template_parts/panel/watchlist');
            break;
          case "req":
            get_template_part('inc/template_parts/panel/req');
            break;
          case "editprofile":
            get_template_part('inc/template_parts/panel/editprofile');
            break;
          case "lists":
            get_template_part('inc/template_parts/panel/lists');
            break;
          case "create_list":
            get_template_part('inc/template_parts/panel/create_list');
            break;
          case "edit_list":
            get_template_part('inc/template_parts/panel/edit_list');
            break;
          case "edit_list_item":
            get_template_part('inc/template_parts/panel/edit_list_item');
            break;
          case "remove_list":
            get_template_part('inc/template_parts/panel/remove_list');
            break;
          case "comments":
            get_template_part('inc/template_parts/panel/comments');
            break;
          case "add_ticket":
            get_template_part('inc/template_parts/panel/add_ticket');
            break;
          case "tickets":
            get_template_part('inc/template_parts/panel/tickets');
            break;
          case "show_ticket":
            get_template_part('inc/template_parts/panel/show_ticket');
            break;
          default:
            // value is not on the list. React accordingly.
            // get_template_part('inc/dashboard.php');
        } ?>
      </div>
    </div>
  </div>
</div>


<?php wp_footer(); ?>

<script>
  jQuery(function() {

    jQuery(document).mouseup(function(e){
        var container = jQuery(".search_fetch_data");
        // hide search
        if (!container.is(e.target) && container.has(e.target).length === 0) 
        {
          container.hide();
        }
    });

    function Counter() {
      jQuery.each(jQuery('.panel_film_sort'), function(i, left) {
        counter = 1;
        jQuery('.listItem', left).each(function() {
          jQuery(this).find('.sort_id').html(counter);
          counter = counter + 1;
        });
      })
    }
    jQuery("#sortable").sortable({
      stop: function(event, ui) {
        Counter();
      }
    });
    // remove item
    jQuery(document).on('click', '.remove_film_item', function() {
      jQuery(this).parent().remove();
      Counter();
      return false;
    });

    jQuery('#panel_search_keyword').on('input', function() {
      var keyword = jQuery('#panel_search_keyword').val();
      if (keyword.length < 1) {
        jQuery('.search_fetch_data').fadeOut();
      }
    });

    jQuery('#search_film_panel').on('click', function() {
      var keyword = jQuery('#panel_search_keyword').val();

      if (keyword.length > 1) {
        jQuery('.search_fetch_data').fadeIn();
        //ajax request
        jQuery.ajax({
          url: ajaxurl,
          type: 'post',
          data: {
            action: 'data_fetch_profile',
            keyword: keyword
          },
          success: function(data) {
            jQuery('.search_fetch_data').html('');
            jQuery('.search_fetch_data').html(data);
          }
        });
      }
    });

    jQuery(document).on('click', '.link_abs', function(e) {
      e.preventDefault();
      var _this = jQuery(this);
      var id = _this.attr('data-id');
      var image = _this.attr('data-image');
      var name = _this.attr('data-name');
      var link = _this.attr('data-link');
      var content = '';

      jQuery('.films_template > .listItem > figure > img').attr('src', image);
      jQuery('.films_template > .listItem > div > div > a > h2').text(name);
      jQuery('.films_template > .listItem > div > div > a').attr('href', link);
      jQuery('.films_template > .listItem > div > .ids').val(id);

      if (jQuery("#p_" + _this.attr('data-id')).length == 0 || jQuery("li.listItem").length == 1) {
        jQuery('.no_data').remove();
        jQuery('.films_template > .listItem').attr('id', 'p_' + _this.attr('data-id'));
        content = jQuery('.films_template > .listItem').clone();
        jQuery('.panel_film_sort').append(content);
        Counter();
      } else {
        alert('فیلم انتخابی در لیست موجود میباشد.')
      }
      return false;
    });

  });
</script>