<?php
/* Template Name: صفحه اختصاصی پخش آنلاین*/
ini_set('display_errors',0);
if (empty($_GET['id']) && empty($_GET['media'])) {
  header('Location: ' . site_url());
} else {
  $post_id = $_GET['id'];
  $user_id = get_current_user_id();
  $season = null;
  $ep = null;
  if(isset($_GET['season'])){
    $season = $_GET['season'];
  }
  if(isset($_GET['ep'])){
    $ep = $_GET['ep'];
  }
  // $is_paid = rcp_is_restricted_content($post_id);
  // $is_active_subscribe = rcp_user_has_active_membership(wp_get_current_user()->ID);
  $config = get_option('my_framework');

  // get post type => serial or film
  if(get_field('post-type', $post_id)){
    $post_type = get_field('post-type', $post_id);
    // post is series get the other seasons and episodes
    if($post_type == 'series'){
      $fs = [];
      if(have_rows('serial-dl', $post_id)){
        while (have_rows('serial-dl', $post_id)) : the_row();
          //get series season's 
          $i = get_row_index();
          $fs[get_row_index()] = ['name'=> get_sub_field('season-name', $post_id), 'eps' => []];
          if (have_rows('dl-links', $post_id)) {
            while (have_rows('dl-links', $post_id)) : the_row();
              // store dl-links row index as $j
              $j = get_row_index();
              $fs[$i]['eps'][$j] = 
              [
                'ep_name' => get_sub_field('episode', $post_id),
                'online' => get_sub_field('online_link_serial', $post_id),
                'online_sub' => get_sub_field('subtitle_online_serial', $post_id),
                'quality'=> []
              ];
              while (have_rows('quality', $post_id)) : the_row();
                $fs[$i]['eps'][$j]['quality'][get_sub_field('quality-name', $post_id)] = get_sub_field('quality-dl-link', $post_id);
              endwhile;
            endwhile;
          } 
        endwhile;
      }
    }elseif($post_type == 'film'){
      $hashed_link = $_GET['media'];
      $encrypted_link = encrypt_decrypt($hashed_link, 'decrypt');
      $subtitle = encrypt_decrypt($_GET['subtitle'], 'decrypt');
      if (isset($_GET['quality1'])) {
        $quality1 = encrypt_decrypt($_GET['quality1'], 'decrypt');
        parse_str(parse_url($quality1)['query'], $params);
        $size1 = filter_var($params['size'], FILTER_SANITIZE_NUMBER_INT);
      } else {
        $quality1 = null;
      }
      if (isset($_GET['quality2'])) {
        $quality2 = encrypt_decrypt($_GET['quality2'], 'decrypt');
        parse_str(parse_url($quality2)['query'], $params);
        $size2 = filter_var($params['size'], FILTER_SANITIZE_NUMBER_INT);
      } else {
        $quality2 = null;
      }
      if (isset($_GET['quality3'])) {
        $quality3 = encrypt_decrypt($_GET['quality3'], 'decrypt');
        parse_str(parse_url($quality3)['query'], $params);
        $size3 = filter_var($params['size'], FILTER_SANITIZE_NUMBER_INT);
      } else {
        $quality3 = null;
      }
    }
  }

  $active_link = $fs[$season]['eps'][$ep];
} ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php if ($config['favicon']['url']) : ?>
  <link rel="icon" type="image" href="<?php echo $config['favicon']['url']; ?> " />
<?php else : ?>
  <link rel="icon" type="image" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" />
<?php endif; ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/plyr.css" />
<?php wp_head();?>
<style id="style_tag">
  /* HTML5 display-role reset for older browsers */
  article,
  aside,
  details,
  figcaption,
  figure,
  footer,
  header,
  hgroup,
  menu,
  nav,
  section {
    display: block;
  }

  body {
    line-height: 1;
    font-size: 100%;
    direction: rtl;
    font-family: <?= $config['font'] ?>;
  }

  ol,
  ul {
    list-style: none;
  }

  blockquote,
  q {
    quotes: none;
  }

  blockquote:before,
  blockquote:after,
  q:before,
  q:after {
    content: '';
    content: none;
  }

  table {
    border-collapse: collapse;
    border-spacing: 0;
  }

  h1{
    font-size: 1.2rem;
  }

  .internet2 {
    position: absolute;
    right: 0;
    color: #fff;
    z-index: 2;
    display: flex;
    margin: 15px;
    font-family: <?= $config['font'] ?>;
    font-size: 17px;
    align-items: center;
  }

  .internet2 span {
    background: #02a1e5;
    padding: 5px 10px;
    border-radius: 50px;
    margin: 0 10px;
  }

  .backButton {
    position: absolute;
    left: 0;
    color: #fff;
    font-size: 25px;
    z-index: 2;
    margin: 15px;
    cursor: pointer;
    background: #4050b5;
    padding: 7px 10px;
    border-radius: 50px;
    line-height: 0;
  }
  .backButton a{
    color: #fff;

  }

  .loading {
    display: none;
    position: absolute;
    top: 50%;
    z-index: 2;
    left: 50%;
    background: #02a1e5;
    color: #fff;
    width: 250px;
    font-family: <?= $config['font'] ?>;
    padding: 10px;
    text-align: center;
    line-height: 1.3;
    transform: translate(-50%, -50%);
    border-radius: 5px;
  }

  .loading2 {
    display: block;
    position: absolute;
    top: 50%;
    z-index: 2;
    left: 50%;
    background: #02a1e5;
    color: #fff;
    width: 250px;
    font-family: <?= $config['font'] ?>;
    padding: 10px;
    text-align: center;
    line-height: 1.3;
    transform: translate(-50%, -50%);
    border-radius: 5px;
  }

  .loader2,
  .loader2:before,
  .loader2:after {
    background: #ffffff;
    -webkit-animation: load1 1s infinite ease-in-out;
    animation: load1 1s infinite ease-in-out;
    width: 1em;
    height: 4em;
  }

  .loader2 {
    color: #ffffff;
    text-indent: -9999em;
    margin: 20px auto;
    position: relative;
    font-size: 11px;
    -webkit-transform: translateZ(0);
    -ms-transform: translateZ(0);
    transform: translateZ(0);
    -webkit-animation-delay: -0.16s;
    animation-delay: -0.16s;
  }

  .loader2:before,
  .loader2:after {
    position: absolute;
    top: 0;
    content: '';
  }

  .loader2:before {
    left: -1.5em;
    -webkit-animation-delay: -0.32s;
    animation-delay: -0.32s;
  }

  .loader2:after {
    left: 1.5em;
  }

  .plyr--full-ui.plyr--video .plyr__control--overlaid {
    background: <?php echo $config['theme_color']; ?>;
  }

  .plyr--video .plyr__control.plyr__tab-focus,
  .plyr--video .plyr__control:hover,
  .plyr--video .plyr__control[aria-expanded=true] {
    background: <?php echo $config['theme_color']; ?> !important;
  }

  .plyr--full-ui input[type=range] {
    color: <?php echo $config['theme_color']; ?> !important;
  }

  .internet2 span {
    background: <?php echo $config['theme_color']; ?>;

  }

  .loading {
    background: <?php echo $config['theme_color']; ?>;
  }

  .loading2 {
    background: <?php echo $config['theme_color']; ?>;
  }

  @-webkit-keyframes load1 {

    0%,
    80%,
    100% {
      box-shadow: 0 0;
      height: 4em;
    }

    40% {
      box-shadow: 0 -2em;
      height: 5em;
    }
  }

  @keyframes load1 {

    0%,
    80%,
    100% {
      box-shadow: 0 0;
      height: 4em;
    }

    40% {
      box-shadow: 0 -2em;
      height: 5em;
    }
  }

  .plyr {
    display: flex;
    height: 100%;
  }

  .plyr iframe {
    display: flex !important;
  }

  .plyr__video-wrapper {
    height: auto !important;
  }

  .btn {
    margin: 5px 0px;
    display: inline-block;
    background: #1c1c22;
    padding: 7px;
    border-radius: 3px;
    color: #fff;
    font-size: 14px;
  }

  .plyr__caption{
    font-size: 2rem;
  }

  .settings_overlay{
    width: 100%;
    height: 100%;
    background-color: #1c1c22;
    position: fixed;
    top: 0;
    right: 0;
    z-index: 3;
    padding: 15px;
    display: none;
    overflow-x: auto;
  }
  .close_btn{
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #4050b5;
    border: none;
    font-size: 15px;
    color: #fff;
    /* position: absolute; */
    /* left: 20px; */
  }
  .toggle_sub{
    background: none;
    border: none;
    color: #fff;
    font-size: 23px;
    border-left: solid 1px #dddddd47;
    padding-left: 6px;
  }
  .settings_overlay__header{
    display: flex;
    justify-content: space-between;
    color: #fff;
    align-items: center;
    margin-bottom: 20px;
  }
  .settings_overlay__body .form-group label{
    color: #fff;
    margin-left: 20px;
    margin-bottom: 25px;
  }
  .settings_overlay__body .form-group select{
    background: #0f0e0e;
    color: #fff;
    border: none;
    padding: 7px 10px 7px;
    border-radius: 7px;
    outline: none;
    font-family: sans-serif;
  }

  input[type="color"] {
    -webkit-appearance: none;
    border: none;
    width: 32px;
    height: 32px;
    border-radius: 50%;
    overflow: hidden;
    padding: 0;
  }
  input[type="color"]::-webkit-color-swatch-wrapper {
    padding: 0;
  }
  input[type="color"]::-webkit-color-swatch {
    border: none;
  }
  .subtitle_preview{
    background: #0f0e0e;
    padding: 40px;
    border-radius: 10px;
    text-align: center;
  }

  .btn{
    padding: 7px;
    background: #4050b5;
    font-weight: 400;
    font-size: 15px;
    border-radius: 6px;
    margin-left: 5px;
  }

  .btn:hover{
    color: #fff;
  }

  .btn-black{
    background: #2b2b36;
  }
  video{
    display: none;
  }
  /* ep overlay */
  .ep_select{
    background: #4050b5;
    border-radius: 50px;
    border: none;
    color: #fff;
    padding: 10px;
    margin-left: 10px;
  }
  .close_btn_ep{
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #4050b5;
    border: none;
    font-size: 15px;
    color: #fff;
    /* position: absolute; */
    /* left: 20px; */
  }
  .ep_overlay{
    width: 100%;
    height: 100%;
    background-color: #1c1c22;
    position: fixed;
    top: 0;
    right: 0;
    z-index: 3;
    padding: 15px;
    display: none;
    overflow-x: auto;
  }
  .ep_overlay__header{
    display: flex;
    justify-content: space-between;
    color: #fff;
    align-items: center;
    margin-bottom: 20px;
  }
  .ep_overlay__body{
    text-align: center;
    color: #fff;
  }
  .ep_overlay__body h2{
    font-size: 1.8rem;
    font-weight: 900;
  }
  .nice-select{
    padding: 4px 60px!important;
    border: solid 1px #40404c !important;
    border-radius: 10px!important;
  }
  .ep_list{
    direction: ltr;
    margin-top: 20px;
  }
  .ep_item{
    display: flex;
    background: #3f404c;
    padding: 10px;
    border-radius: 15px;
    justify-content: center;
    height: 280px;
    align-items: flex-end;
  }
  .ep_item a div{
    display: block;
    background: #1c1c2382;
    width: 100%;
    border-radius: 5px;
    padding: 10px;
    font-size: 1rem;
    font-weight: 500;
    backdrop-filter: blur(5px);
  }
  .ep_item a{
    display: block;
    width: 100%;
    color: #fff;
  }
  .ep_item img{
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    object-fit: cover;
    height: 100%;
    border-radius: 12px;
  }
  .owl-stage{
    padding-right: 0!important;
  }
  .owl-nav{
    display: none;
  }
</style>

<title><?php bloginfo('name'); ?> | <?php _e('پخش آنلاین', 'kelaketfilm') ?> <?php echo get_the_title($post_id); ?></title>
<div class="settings_overlay">
  <div class="settings_overlay__header">
    <h1>
      <?php _e('تنظیمات پخش آنلاین', 'kelaketfilm') ?>
    </h1>
    <button class="close_btn">
      <i class="fa-regular fa-x"></i>
    </button>
  </div>
  <div class="settings_overlay__body">
    <div class="form-group">
      <label for="fontSize"><?php _e('سایز فونت', 'kelaketfilm') ?></label>
      <select id="kelaket_fontsize" name="fontSize">
        <?php for($x = 15; $x <= 50; $x++):
        if($x % 2 == 0):  
        ?>
        <option value="<?php echo $x ?>"><?php echo $x ?>px</option>
        <?php endif; endfor; ?>
      </select>
    </div>

    <div class="form-group">
      <label for="fontWeight"><?php _e('ضخامت فونت', 'kelaketfilm') ?></label>
      <select id="kelaket_fontweight" name="fontWeight">
        <option value="100">Light</option>
        <option selected value="300">Normal</option>
        <option value="500">Bold</option>
        <option value="600">Black</option>
      </select>
    </div>

    <div class="form-group">
      <label for="textColor"><?php _e('رنگ متن', 'kelaketfilm') ?></label>
      <input id="kelaket_color" type="color" value="#ffffff" name="textColor">
    </div>

    <div class="form-group">
      <label for="background"><?php _e('رنگ پس‌زمینه', 'kelaketfilm') ?></label>
      <input id="kelaket_bg" type="color" value="#000000" name="background">
    </div>

    <section class="subtitle_preview">
      <span class="plyr__caption"><?php _e('زیرنویس پخش آنلاین', 'kelaketfilm') ?></span>
    </section>

    <div class="form-group mt-3">
      <button class="btn save_settings"><?php _e('ذخیره تغییرات', 'kelaketfilm') ?></button>
      <button class="btn btn-black sub_default"> <?php _e('بازنشانی به پیشفرض', 'kelaketfilm') ?></button>
    </div>
  </div>
</div>

<div class="ep_overlay">
  <div class="ep_overlay__header">
    <h1>
      <?php _e('انتخاب قسمت و فصل', 'kelaketfilm') ?>
    </h1>
    <button class="close_btn_ep">
      <i class="fa-regular fa-x"></i>
    </button>
  </div>
  <?php
  if($post_type == 'series'):
  ?>
  <div class="ep_overlay__body">
    <h2><?php _e('قسمت های دیگر', 'kelaketfilm'); ?></h2>
    <p class="mt-3">قسمت و فصل مورد نطر را انتخاب کنید.</p>
    <div class="d-flex justify-content-center align-items-center">
      <select class="ns_select season_select" name="season_select">
        <?php foreach($fs as $index => $item): ?>
        <option <?php echo $season == $index ? 'selected': '' ?> value="<?php echo $index ?>"><?php echo $item['name'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-lg-6 m-auto">
      <?php foreach($fs as $index => $item):
        $temp_season = $index;
        ?>
      <div class="ep_list" data-index="<?php echo $index; ?>">
        <div class="owl-carousel season_carousel">
          <?php foreach($fs[$index]['eps'] as $index => $episode): ?>
          <div class="ep_item">
            <a href="<?php echo site_url() ?>/playonline?id=<?php echo $post_id ?>&season=<?php echo $temp_season ?>&ep=<?php echo $index; ?>">
              <?php echo get_the_post_thumbnail($post_id, 'post_retina'); ?>
              <div>
              <?php echo $episode['ep_name'] ?>
              </div>
            </a>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
  <?php endif; //series checking condition ?>
</div>

<div class="main_video">
  <?php
  if (kelaket_user_access($user_id, $post_id)) :
  ?>
    <div class="internet2">
      <?php if($post_type == 'series'): ?>
      <button class="ep_select">
        <i class="fa fa-list"></i>
      </button>
      <?php endif; ?>
    </div>
    <div id="backBtn" class="backButton">
      <button class="toggle_sub">
        <i class="fa fa-closed-captioning"></i>
      </button>
      <a href="<?php the_permalink($post_id); ?>">
        <i class="fa fa-delete-left"></i>
      </a>
    </div>
    <div class="loading">
      <div style="width: 100%;height: 74px;">
        <div class="loader2"><?php _e('درحال بارگذاری', 'kelaketfilm') ?></div>
      </div>
      <div style="font-weight: bold; margin: 10px 0;"><?php _e('درحال بارگذاری', 'kelaketfilm') ?></div>
    </div>
    <!-- playsinline -->
    <?php if($post_type == 'series'):?>
      <video id="player" autoplay controls data-poster="">
        <source src="<?php echo $active_link['online'] ?>" type="video/mp4" />
        <?php
        if($active_link['quality'] && theme_options('dont_pass_quality') == false):
          foreach($active_link['quality'] as $index => $value):?>
            <source src="<?php echo $value ?>" type="video/mp4" size="<?php echo filter_var($index, FILTER_SANITIZE_NUMBER_INT); ?>" />
          <?php endforeach;
        endif;
        ?>
        <?php if ($active_link['online_sub']): ?>
        <track id="track" kind="captions" label="زیرنویس فارسی" data-src="<?php echo $active_link['online_sub']; ?>" srclang="fa" default />
        <?php endif; ?>
      </video>
    <?php else: //movies online player ?>
      <video id="player" controls data-poster="">
        <source src="<?php echo $encrypted_link ?>" type="video/mp4" />
        <?php if(theme_options('dont_pass_quality') == false): ?>
        <source src="<?php echo $quality1 ?>" type="video/mp4" size="<?php echo $size1 ?>" />
        <source src="<?php echo $quality2 ?>" type="video/mp4" size="<?php echo $size2 ?>" />
        <source src="<?php echo $quality3 ?>" type="video/mp4" size="<?php echo $size3 ?>" />
        <?php endif; ?>
        <?php if($subtitle): ?>
          <track id="track" kind="captions" label="زیرنویس فارسی" data-src="<?php echo $subtitle; ?>" srclang="fa" default />
        <?php endif; ?>
    </video>
    <?php endif; ?>
  <?php else : ?>
    <div class="loading2">
      <?php if (!is_user_logged_in()) : ?>
        <div style="font-weight: bold; margin: 10px 0;"><?php _e('برای پخش فیلم وارد اکانت خود بشوید', 'kelaketfilm') ?></div>
        <a class="btn" href="<?php bloginfo('url'); ?>/login"><?php _e('ورود', 'kelaketfilm') ?></a>
        <a class="btn" href="<?php bloginfo('url'); ?>/register"><?php _e('ثبت نام', 'kelaketfilm') ?></a>
      <?php else : ?>
        <div style="font-weight: bold; margin: 10px 0;"><?php _e('پخش فیلم برای شما امکان پذیر نیست', 'kelaketfilm') ?></div>
        <div style="font-size: 14px"><?php _e('لطفا اقدام به خرید اشتراک کنید', 'kelaketfilm') ?></div>
        <a class="btn" href="<?php bloginfo('url'); ?>/panel?action=vip"><?php _e('خرید اشتراک', 'kelaketfilm') ?></a>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>
<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/plyr.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/hls.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/nice-select.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/owl.carousel.min.js"></script>
<script>
  $(document).ready(function(){
    $('.ns_select').niceSelect();

    $('.ep_list').fadeOut('fast');

    <?php if($season): ?>
    $('.ep_list').each(function(i, el){
      if($(el).data('index') == <?php echo $season ?>){
        $(el).fadeIn('fast');
      }
    });
    <?php else: ?>
      $('.ep_list').each(function(i, el){
        if($(el).data('index') == 1){
          $(el).fadeIn('fast');
        }
      });
    <?php endif; ?>

    <?php if(!isset($season) && !isset($ep) && $post_type == 'series'): ?>
      $('.ep_overlay').fadeIn('fast');
    <?php endif; ?>

    $(".season_select").on('change', function(e){
      var value = $(this).find("option:selected").attr('value');
      $('.ep_list').fadeOut('fast');
      setTimeout(function(){
        $('.ep_overlay').find(".ep_list[data-index = '"+value+"']").fadeIn('fast');
      },300)
    });

    $('.season_carousel').owlCarousel({
      margin:20,
      rtl: true,
      nav:true,
      stagePadding: 30,
      dots: false,
      responsive:{
          0:{
              items:1
          },
          600:{
              items:3
          },
          1000:{
              items:4
          }
      }
    });

    $('.sub_default').on('click', function(){
      var settings = {
        fontSize: 24,
        fontWeight: 300,
        color: '#ffffff',
        bg: '#000000'
      };

      localStorage.setItem('kelaket_sub', JSON.stringify(settings));

      $('.plyr__caption').css('font-size', settings.fontSize+'px');
      $('.plyr__caption').css('font-weight', settings.fontWeight);
      $('.plyr__caption').css('color', settings.color);
      $('.plyr__caption').css('background-color', settings.bg);
    });


    $('#kelaket_fontsize').on('change', function(e){
      $('.plyr__caption').css('font-size', e.target.value);
    });

    $('#kelaket_fontweight').on('change', function(e){
      $('.plyr__caption').css('font-weight', e.target.value);
    });

    $('#kelaket_color').on('change', function(e){
      $('.plyr__caption').css('color', e.target.value);
    });

    $('#kelaket_bg').on('change', function(e){
      $('.plyr__caption').css('background-color', e.target.value);
    });


    // set saved settings
    if(localStorage.getItem('kelaket_sub')){
      var settings = JSON.parse(localStorage.getItem('kelaket_sub'));
      $('#kelaket_fontsize').val(settings.fontSize);
      $('#kelaket_fontweight').val(settings.fontWeight);
      $('#kelaket_color').val(settings.color);
      $('#kelaket_bg').val(settings.bg);

      $('.plyr__caption').css('font-size', settings.fontSize+'px');
      $('.plyr__caption').css('font-weight', settings.fontWeight);
      $('.plyr__caption').css('color', settings.color);
      $('.plyr__caption').css('background-color', settings.bg);

      // populate plyr__caption class
      $('#style_tag').append(`.plyr__caption{ font-size: ${settings.fontSize}px; font-weight: ${settings.fontWeight}; color: ${settings.color}; background-color: ${settings.bg} }`);

    }

    $('.save_settings').on('click', function(){
      _this = $(this);
      _this.text('درحال ذخیره سازی...');
      //user defined values
      var font_size = $('#kelaket_fontsize').val();
      var font_weight = $('#kelaket_fontweight').val();
      var color = $('#kelaket_color').val();
      var bg = $('#kelaket_bg').val();

      var settings = {
        fontSize: font_size,
        fontWeight: font_weight,
        color: color,
        bg: bg
      };

      localStorage.setItem('kelaket_sub', JSON.stringify(settings));

      $('.plyr__caption').css('font-size', settings.fontSize+'px');
      $('.plyr__caption').css('font-weight', settings.fontWeight);
      $('.plyr__caption').css('color', settings.color);
      $('.plyr__caption').css('background-color', settings.bg);

      // populate plyr__caption class
      $('#style_tag').append(`.plyr__caption{ font-size: ${settings.fontSize}px; font-weight: ${settings.fontWeight}; color: ${settings.color}; background-color: ${settings.bg} }`);
      
      setTimeout(function(){
        _this.text('ذخیره تغییرات');
      }, 1000);

    });


    $('.close_btn').on('click', function(){
      $('.settings_overlay').fadeToggle('fast');
    });

    $('.toggle_sub').on('click', function(){
      $('.settings_overlay').fadeToggle('fast');
    });

    $('.close_btn_ep').on('click', function(){
      $('.ep_overlay').fadeToggle('fast');
    });

    $('.ep_select').on('click', function(){
      $('.ep_overlay').fadeToggle('fast');
    });

    

  var track = $('track');
  var backButton = document.getElementById('backBtn');
  <?php if($post_type == 'series'): ?>
  var link = '<?= $active_link['online'] ?>';
  <?php else: ?>
  var link = '<?= $encrypted_link; ?>';
  <?php endif; ?>
  var video = document.getElementById('player');
  var player = '';
  var config = {
    iconUrl: '<?php echo get_template_directory_uri() ?>/images/plyr.svg',
    captions: {active: true, language: 'fa', update: true},
    tooltips: { controls: true, seek: true },
    i18n: { 
      play: '<?php _e('پخش', 'kelaketfilm') ?>',
      rewind: '<?php _e('۱۰ ثانیه به عقب', 'kelaketfilm') ?>',
      fastForward: '<?php _e('۱۰ ثانیه به جلو', 'kelaketfilm') ?>',
      mute: '<?php _e('بی صدا', 'kelaketfilm') ?>',
      unmute: '<?php _e('صدا دار', 'kelaketfilm') ?>',
      quality: '<?php _e('کیفیت', 'kelaketfilm') ?>',
      speed: '<?php _e('سرعت', 'kelaketfilm') ?>',
      settings: '<?php _e('تنظیمات', 'kelaketfilm') ?>',
      captions: '<?php _e('زیرنویس', 'kelaketfilm') ?>',
      pip: '<?php _e('تصویر در تصویر', 'kelaketfilm') ?>',
      enterFullscreen: '<?php _e('تمام صفحه', 'kelaketfilm') ?>',
      normal: '<?php _e('معمولی', 'kelaketfilm') ?>',
    },
    controls: ['play-large','rewind', 'play', 'fast-forward', 'progress', 'current-time', 'mute', 'volume','captions' ,'settings', 'airplay', 'pip', 'fullscreen'],
    quality : { default: 720 , options: [1080, 720, 480, 360, 240] },
  };


  if (Hls.isSupported() && getExt(link) == 'm3u8') {
    const hls = new Hls();
    hls.loadSource(link);

    hls.on(Hls.Events.MANIFEST_PARSED, function() {
    console.log('hls detected');

      const availableQualities = hls.levels.map((l) => l.height)

      config.quality = {
        default: availableQualities[0],
        options: availableQualities.reverse(),
        forced: true,
        onChange: (e) => updateQuality(e),
      }

      player = new Plyr(video, config);
      $('video').fadeIn('fast');
    });

    hls.attachMedia(video);
    window.hls = hls;
  }else{
    player = new Plyr(video,config);
    $('video').fadeIn('fast');
  }

  function updateQuality(newQuality) {
    window.hls.levels.forEach((level, levelIndex) => {
      if (level.height === newQuality) {
        window.hls.currentLevel = levelIndex;
      }
    });
  }

  if (track.length != 0) {
    switch (getExt(track.data('src'))) {
      case "srt":
        getSubtitleContent(track.data('src'), true);
        break;

      case "vtt":
        getSubtitleContent(track.data('src'), false);
        break;
      default:
        console.log("Faghat Format .vtt va .srt support mishavad");
        break;
    }
  }

  function getSubtitleContent(url, isSRT = false) {
    $.ajax({
      url: url,
      type: 'GET',
      success: function(text) {
        if (isSRT === true) {
          document.getElementById("track").setAttribute('src', vttToBlob(srtToVtt(text)));
        } else {
          document.getElementById("track").setAttribute('src', vttToBlob(text));
        }
        document.getElementById("track").removeAttribute('data-src');
      },
      error: function(error) {
        console.log(error)
      }
    });
    return false;
  }

  function srtToVtt(text) {
    return 'WEBVTT \r\n\r\n'.concat(text.replace(/{[\s\S]*?}/g, '').replace(/\{\\([ibu])\}/g, '</$1>').replace(/\{\\([ibu])1\}/g, '<$1>').replace(/\{([ibu])\}/g, '<$1>').replace(/\{\/([ibu])\}/g, '</$1>').replace(/(\d\d:\d\d:\d\d),(\d\d\d)/g, '$1.$2').concat('\r\n\r\n'));
  }

  function vttToBlob(text) {
    return URL.createObjectURL(new Blob([text], {
      type: 'text/vtt'
    }));
  }

  function getExt(url) {
    if (typeof url == 'undefined') return;

    if (url.includes('?')) {
      return getExt(url.split('?')[0]);
    }

    if (url.includes('#')) {
      return getExt(url.split('#')[0]);
    }

    return url.trim().toLowerCase().split('.').pop();
  }
});

</script>