<?php
/* Template Name: صفحه اختصاصی پروفایل کاربران */
$config = get_option('my_framework');
?>
<?php get_header(); ?>
<div class="container after_fe2">
  <div class="row text-center">
    <?php
    if ($users_filter_name = get_query_var('username')) {
      $user = get_user_by('slug', $users_filter_name);
      if (!empty($user)) {
        $user_id = $user->ID;
    ?>
        <div class="profile__avatar">
          <?php echo get_avatar($user_id, 130); ?>
          <h1><?php echo $user->display_name; ?></h1>
        </div>
        <ul class="nav nav-pills profile_tab mt-3 mb-3 justify-content-center" id="pills-tab" role="tablist">
          <li class="nav-item mb-2" role="presentation">
            <button class="nav-link active" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="true"><i class="fa fa-list"></i> لیست های ساخته شده</button>
          </li>
          <li class="nav-item mb-2" role="presentation">
            <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact" type="button" role="tab" aria-controls="pills-contact" aria-selected="false"><i class="fa fa-comments"></i> نظرات ارسالی</button>
          </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
          <div class="tab-pane fade show active" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">

            <div class="row mt-5">
              <?php
              global $wpdb;
              $tablename = $wpdb->prefix . 'kelaket_lists';
              $pagenum = (get_query_var('paged')) ? get_query_var('paged') : 1;
              $limit = 9;
              $offset = ($pagenum - 1) * $limit;
              $total = $wpdb->get_var("SELECT COUNT(*) FROM $tablename");
              $num_of_pages = ceil($total / $limit);

              $qry = "select * from $tablename WHERE is_private = false AND user_id = $user_id ORDER BY id DESC";
              $result = $wpdb->get_results($qry);
              foreach ($result as $item) :
                $user = get_user_by('id', $item->user_id);
                $films = explode(',', $item->films);
                if (empty($films[0])) {
                  $count = 0;
                } else {
                  $count = count($films);
                }
                // fix first image issue due the first index of array alwasy empty 
                if (!get_the_post_thumbnail_url($films[0], 'post_retina')) {
                  $firstImage = get_template_directory_uri() . '/images/nocover.jpeg';
                } else {
                  $firstImage = get_the_post_thumbnail_url($films[0], 'post_retina');
                }
              ?>
                <div class="col-xl-3 col-lg-6 col-md-6">
                  <div class="custom_list">
                    <a href="<?php echo site_url() . "/lists/$item->id" ?>">
                      <div class="custom_list_images">
                        <img src="<?php echo $firstImage ?>" alt="">
                        <img src="<?php echo checkIndexExists($films, 1) ?  get_the_post_thumbnail_url($films[1], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                        <img src="<?php echo checkIndexExists($films, 2) ? get_the_post_thumbnail_url($films[2], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                        <img src="<?php echo checkIndexExists($films, 3) ? get_the_post_thumbnail_url($films[3], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                      </div>
                    </a>
                    <h3>
                      <a data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $item->name; ?>" class="list" href="<?php echo site_url() . "/lists/$item->id" ?>"><?php echo limited_excerpt($item->name, 20) ?></a>
                      <?php _e('توسط', 'kelaketfilm') ?>
                      <a class="author" href="<?php echo bloginfo('url') . '/profile/' . $user->ID;  ?>"><?php echo $user->display_name; ?></a>
                    </h3>
                    <div class="custom_list_meta">
                      <span> <?php _e('تعداد: ', 'kelaketfilm') ?> <?php echo $count; ?></span>
                      <?php
                      //check if post updated show date as tooltip
                      if ($item->updated_at == '0000-00-00 00:00:00') {
                        $update = "";
                      } else {
                        $update = __('آخرین بروزرسانی: ', 'kelaketfilm') . mysql2date(' F j, Y', $item->updated_at);
                      }
                      ?>
                      <span data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $update; ?>"><?php echo  mysql2date(' F j, Y', $item->created_at) ?></span>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>

          </div>
          <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab">
            <!-- comments -->
            <div id="comments" class="comments-area">
              <ol class="comment-list">
                <div class="row text-start">
                <?php
                  $args = array(
                    'user_id' => $user_id
                  );
                  $comments = get_comments($args);

                  foreach ($comments as $comment) { ?>
                    <div class="col-xl-6 col-sm-6 col-md-6">
                    <li class="comment byuser comment-author-imahmoodzz bypostauthor even thread-even depth-1" id="li-comment-18">
                      <div id="comment-18">
                        <div class="comment-author vcard">
                          <?php echo get_avatar($user_id, 40); ?>
                          <cite class="fn"><a href="<?php the_permalink($comment->comment_post_ID); ?>" rel="external nofollow ugc" class="url"><?php echo $comment->comment_author; ?></a></cite> <span class="says"><?php _e('میگه', 'kelaketfilm') ?></span>
                        </div>
                        <div class="comment-meta commentmetadata">
                          <a href="<?php the_permalink($comment->comment_post_ID); ?>">
                          <?php echo get_comment_date(); ?>
                          </a>
                        </div>
                        <div class="no_spoil">
                          <p><?php echo $comment->comment_content; ?></p>
                        </div>
                      </div>
                    </li>
                  </div>
                  <?php } ?>
                  
                </div>
              </ol>
            </div>
            <!-- comments -->
          </div>
        </div>
    <?php } else {
        wp_redirect(home_url());
      }
    }
    ?>
  </div>
</div>


<?php get_footer(); ?>