<?php
/* Template Name: صفحه مشترک ورود و عضویت با ایمیل*/
global $wp;
$current = $wp->request;
$config = get_option('my_framework');
?>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php wp_head();  ?>
<style>
  .ajax_form__register, .ajax_from__login{
    background: <?= $config['theme_color'] ?>;
    border: solid 1px <?= $config['theme_color'] ?>;
  }
</style>


<div style="direction: <?php echo is_rtl() ? 'rtl' : 'ltr' ?>;">
<?php
if($current == 'register' && !is_user_logged_in()){
  // register form
  get_template_part('inc/template_parts/register_form');
}else if($current == 'login' && !is_user_logged_in()){
  // login form
  get_template_part('inc/template_parts/login_form');
}else{
  wp_redirect( home_url() ); exit;
}

wp_footer();
?>
</div>


<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/toastr.min.js"></script>
<script>
  $('#ajax_register').submit(function (e) {
    e.preventDefault();
    $.ajax({
      type: 'POST',
      dataType: 'json',
      url: '<?php echo admin_url('admin-ajax.php'); ?>',
      data: {
        'action': 'register', //calls wp_ajax_nopriv_ajaxlogin
        'username': $('.register_username').val(),
        'email': $('.register_email').val(),
        'password': $('.register_pass').val(),
        'password2': $('.register_pass2').val(),
        'phone': $('.register_phone').val()
        // 'nonce': $('#wg_ajax_nonce').val()
      },
      beforeSend: function () {
        // Show user a message that details are being checked
        $('.load_overlay').fadeIn();
      },
      success: function (data) {
        $('.load_overlay').fadeOut();
        if (data.register == true) {
          // Show success message if user details exist
          $('.msg').fadeIn();
          $('.msg').html('<div class="rcp_success">ثبت نام با موفقیت انجام شد! درحال انتقال به پنل کاربری</div>');
          // Create timer to refresh page after successfull login
          setTimeout(function () {
            document.location.href = '<?php bloginfo('url') ?>/panel';
          }, 2000);
        } else if (data.register == false) {
          // Show failure message if user details doesn't exist
          $('.msg').fadeIn();
          $('.msg').html('');
          if(data.error){
            $('.msg').append('<div class="rcp_error error">' + data.error + '</div>')
          }

          for (var prop in data.errors) {
            console.log(prop, data.errors[prop][0])
            $('.msg').append('<div class="rcp_error error">' + data.errors[prop][0] + '</div>')
          }
        }
      }
    });
  });

  $('#ajax_login').submit(function (e) {
    e.preventDefault();
    $.ajax({
      type: 'POST',
      dataType: 'json',
      url: '<?php echo admin_url('admin-ajax.php'); ?>',
      data: {
        'action': 'login_', //calls wp_ajax_nopriv_ajaxlogin
        'username': $('.login_username').val(),
        'password': $('.login_password').val(),
        // 'nonce': $('#wg_ajax_nonce').val()
      },
      beforeSend: function () {
        // Show user a message that details are being checked
        $('.load_overlay').fadeIn();
      },
      success: function (data) {
        $('.load_overlay').fadeOut();
        if (data.loggedin == true) {
          // Show success message if user details exist
          $('.msg').fadeIn();
          $('.msg').html('<div class="rcp_success">با موفقیت وارد شدید! درحال انتقال...</div>');
          // Create timer to refresh page after successfull login
          setTimeout(function () {
            document.location.href = '<?php bloginfo('url') ?>/panel';
          }, 2000);
        } else if (data.loggedin == false) {
          // Show failure message if user details doesn't exist
          $('.msg').fadeIn();
          $('.msg').html('');

          for (var prop in data.errors) {
            console.log(prop, data.errors[prop][0])
            $('.msg').append('<div class="rcp_error error">' + data.errors[prop][0] + '</div>')
          }
        }
      }
    });
  });
</script>