<?php
/* Template Name: صفحه فراموش رمز */
global $wp;
$current = $wp->request;
$config = get_option('my_framework');
?>
<title><?php bloginfo('name') ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<!-- Bootstrap core CSS -->
<link href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/style.css" rel="stylesheet">
<?php if ($config['favicon']['url']) : ?>
  <link rel="icon" type="image" href="<?php echo $config['favicon']['url']; ?> " />
<?php else : ?>
  <link rel="icon" type="image" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" />
<?php endif; ?>
<?php wp_head();  ?>
<style>
  .ajax_form__register,
  .ajax_from__login {
    background: <?= $config['theme_color'] ?>;
    border: solid 1px <?= $config['theme_color'] ?>;
  }
</style>


<div style="direction: <?php echo is_rtl() ? 'rtl' : 'ltr' ?>;">
<?php
if ($current == 'reset-pass' && !is_user_logged_in()) {
  // resetpass form
  get_template_part('inc/template_parts/resetpass_form');
} else {
  wp_redirect(home_url());
  exit;
}
?>
</div>


<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/toastr.min.js"></script>
<script>
  $('#ajax_resetpass').submit(function(e) {
    e.preventDefault();
    $.ajax({
      type: 'POST',
      dataType: 'json',
      url: '<?php echo admin_url('admin-ajax.php'); ?>',
      data: {
        'action': 'reset_password', //calls wp_ajax_nopriv_reset_password
        'email': $('.login_email').val(),
      },
      beforeSend: function() {
        // Show user a message that details are being checked
        $('.load_overlay').fadeIn();
      },
      success: function(data) {
        console.log(data);
        $('.load_overlay').fadeOut();
        if (data.sent == true) {
          // Show success message if user details exist
          $('.msg').fadeIn();
          $('.msg').html('<div class="rcp_success">ایمیل ریست پسورد با موفقیت برای شما ارسال شد.</div>');
        } else if (data.sent == false) {
          if (data.wp_error) {
            $('.msg').fadeIn();
            $('.msg').html('');

            $('.msg').append('<div class="rcp_error error">' + data.msg + '</div>')
          } else {
            // Show failure message if user details doesn't exist
            $('.msg').fadeIn();
            $('.msg').html('');

            $('.msg').append('<div class="rcp_error error">' + data.error + '</div>')
          }

        }
      }
    });
  });
</script>