<?php
$config = get_option('my_framework');
?>
<?php get_header(); ?>

<div class="container after_fe2">
  <div class="row">
    <div class="col-xl-9 col-lg-8 col-md-12 col-sm-12 col-xs-12 col-xxl-9">
      <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
          <article class="post">
            <div class="row">
              <div class="post_blog post_page col-lg-12 col-md-12">
                <?php the_post_thumbnail('blog-single', array('class' => 'blog_image')); ?>
                <div class="text-center">
                  <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                  <ul class="blog_meta">
                    <li><i class="fa-duotone fa-user"></i> <?php _e('نویسنده: ', 'kelaketfilm') ?> <?php the_author(); ?></li>
                    <li><i class="fa-duotone fa-calendar"></i><?php the_date('d M Y'); ?></li>
                    <li><i class="bi bi-filter-square-fill"></i><?php echo get_the_term_list($post->ID, 'blog_category', '', '، ', '') ?></li>
                  </ul>
                </div>
                <?php the_content(); ?>
              </div>
            </div>
          </article>
          <?php endwhile;
      else : ?><?php endif; ?>
          <section class="comments blog_comments">
            <?php
            $comments_count = wp_count_comments(get_the_ID());
            if ($comments_count->approved > 0) {
            ?>
              <div class="comments_title">
                <i class="bi bi-chat-dots-fill"></i>
                <h4><?php echo $comments_count->approved . ""; ?> <?php _e('دیدگاه', 'kelaketfilm') ?></h4>
              </div>
            <?php } ?>
            <div class="comments_inner">
              <?php
              if (comments_open()) {
                comments_template();
              }
              ?>
            </div>
          </section>
    </div>


    <?php get_sidebar(); ?>
  </div>
</div>


<?php get_footer(); ?>