<?php
get_header(); ?>

<div class="container after_fe2">
  <div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 col-xxl-12">


      <div class="container">
        <div class="stars_page row">
          <?php
          $taxonomy = get_queried_object();
          ?>
          <div class="col-xl-3 col-lg-3 col-md-4 col-sm-5 col-xs-12 col-xxl-2 actor-center">
            <?php if (get_field('actor_image_link', $taxonomy)) { ?>
              <img src="<?php echo get_field('actor_image_link', $taxonomy) ?>" alt="brat" />
            <?php } else { ?>
              <img src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
            <?php } ?>
          </div>
          <div class="col-xl-9 col-lg-9 col-md-8 col-sm-7 col-xs-12 col-xxl-10 actor-center">
            <h1><?php echo $taxonomy->name; ?></h1>
            <p>
              <?php
              $bio = $taxonomy->description;
              if (empty($bio)) {
                 _e('بیوگرافی ثبت نشده است.', 'kelaketfilm');
              } else {
                echo $bio;
              }
              ?>
            </p>
          </div>
        </div>


        <div class="actor-works row">
          <h2><?php _e('آثار این کارگردان', 'kelaketfilm') ?></h2>
          <?php
          $term_id = $taxonomy->term_id;
          $the_query = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => '-1',
            'tax_query' => array(
              array(
                'taxonomy' => 'director',
                'field' => 'term_id',
                'terms' => $term_id,
              )
            ),
          )); ?>

          <?php
          while ($the_query->have_posts()) : $the_query->the_post(); ?>
            <section class="col-xl-3 col-lg-4 col-md-6 col-sm-12 col-12 col-xxl-3">
              <div class="artist_works d-flex">
                <a href="<?php the_permalink(); ?>">
                  <?php the_post_thumbnail('post-single'); ?>
                </a>
                <div class="d-flex flex-column pe-3 w-100">
                  <a href="<?php the_permalink(); ?>">
                    <div class="artist_title"><?php the_title(); ?></div>
                  </a>
                  <div class="imdb_rate"> <?php the_field('imdbRating') ?> <i class="fa-solid fa-star"></i></div>
                  <div class="a_genres">
                  <?php if (get_the_term_list(get_the_ID(), 'genre', '', ' ', '')) : ?>
                    <?php echo get_the_term_list(get_the_ID(), 'genre', '', ' ', ''); ?>
                  <?php endif; ?>
                  </div>
                </div>
              </div>
            </section>
          <?php endwhile;
          wp_reset_postdata();
          ?>

        </div>
      </div>
    </div>
  </div>
</div>

</div>

<?php get_footer(); ?>